/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.LocalAuthentication;
import org.sonar.server.authentication.RealmAuthenticator;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class CredentialsAuthenticator {
    private final DbClient dbClient;
    private final RealmAuthenticator externalAuthenticator;
    private final AuthenticationEvent authenticationEvent;
    private final LocalAuthentication localAuthentication;

    public CredentialsAuthenticator(DbClient dbClient, RealmAuthenticator externalAuthenticator, AuthenticationEvent authenticationEvent, LocalAuthentication localAuthentication) {
        this.dbClient = dbClient;
        this.externalAuthenticator = externalAuthenticator;
        this.authenticationEvent = authenticationEvent;
        this.localAuthentication = localAuthentication;
    }

    public UserDto authenticate(String userLogin, String userPassword, HttpServletRequest request, AuthenticationEvent.Method method) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.authenticate(dbSession, userLogin, userPassword, request, method);
            return userDto;
        }
    }

    private UserDto authenticate(DbSession dbSession, String userLogin, String userPassword, HttpServletRequest request, AuthenticationEvent.Method method) {
        UserDto localUser = this.dbClient.userDao().selectActiveUserByLogin(dbSession, userLogin);
        if (localUser != null && localUser.isLocal()) {
            this.localAuthentication.authenticate(dbSession, localUser, userPassword, method);
            dbSession.commit();
            this.authenticationEvent.loginSuccess(request, userLogin, AuthenticationEvent.Source.local(method));
            return localUser;
        }
        Optional<UserDto> externalUser = this.externalAuthenticator.authenticate(userLogin, userPassword, request, method);
        if (externalUser.isPresent()) {
            return externalUser.get();
        }
        throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(method)).setLogin(userLogin).setMessage(localUser != null && !localUser.isLocal() ? "User is not local" : "No active user for login").build();
    }
}

