/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class Cookies {
    private static final String HTTPS_HEADER = "X-Forwarded-Proto";
    private static final String HTTPS_VALUE = "https";

    private Cookies() {
    }

    public static Optional<Cookie> findCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(cookie -> cookieName.equals(cookie.getName())).findFirst();
    }

    public static CookieBuilder newCookieBuilder(HttpServletRequest request) {
        return new CookieBuilder(request);
    }

    public static class CookieBuilder {
        private final HttpServletRequest request;
        private String name;
        private String value;
        private boolean httpOnly;
        private int expiry;

        public CookieBuilder(HttpServletRequest request) {
            this.request = request;
        }

        public CookieBuilder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public CookieBuilder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public CookieBuilder setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public CookieBuilder setExpiry(int expiry) {
            this.expiry = expiry;
            return this;
        }

        public Cookie build() {
            Cookie cookie = new Cookie(Objects.requireNonNull(this.name), this.value);
            cookie.setPath(CookieBuilder.getContextPath(this.request));
            cookie.setSecure(CookieBuilder.isHttps(this.request));
            cookie.setHttpOnly(this.httpOnly);
            cookie.setMaxAge(this.expiry);
            return cookie;
        }

        private static boolean isHttps(HttpServletRequest request) {
            return Cookies.HTTPS_VALUE.equalsIgnoreCase(request.getHeader(Cookies.HTTPS_HEADER));
        }

        private static String getContextPath(HttpServletRequest request) {
            String path = request.getContextPath();
            return Strings.isNullOrEmpty((String)path) ? "/" : path;
        }
    }
}

