/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.CredentialsAuthenticator;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.usertoken.UserTokenAuthenticator;

public class BasicAuthenticator {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BASIC_AUTHORIZATION = "BASIC";
    private final DbClient dbClient;
    private final CredentialsAuthenticator credentialsAuthenticator;
    private final UserTokenAuthenticator userTokenAuthenticator;
    private final AuthenticationEvent authenticationEvent;

    public BasicAuthenticator(DbClient dbClient, CredentialsAuthenticator credentialsAuthenticator, UserTokenAuthenticator userTokenAuthenticator, AuthenticationEvent authenticationEvent) {
        this.dbClient = dbClient;
        this.credentialsAuthenticator = credentialsAuthenticator;
        this.userTokenAuthenticator = userTokenAuthenticator;
        this.authenticationEvent = authenticationEvent;
    }

    public Optional<UserDto> authenticate(HttpServletRequest request) {
        String authorizationHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authorizationHeader == null || !authorizationHeader.toUpperCase(Locale.ENGLISH).startsWith(BASIC_AUTHORIZATION)) {
            return Optional.empty();
        }
        String[] credentials = BasicAuthenticator.getCredentials(authorizationHeader);
        String login = credentials[0];
        String password = credentials[1];
        UserDto userDto = this.authenticate(login, password, request);
        return Optional.of(userDto);
    }

    private static String[] getCredentials(String authorizationHeader) {
        String basicAuthEncoded = authorizationHeader.substring(6);
        String basicAuthDecoded = BasicAuthenticator.getDecodedBasicAuth(basicAuthEncoded);
        int semiColonPos = basicAuthDecoded.indexOf(58);
        if (semiColonPos <= 0) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC)).setMessage("Decoded basic auth does not contain ':'").build();
        }
        String login = basicAuthDecoded.substring(0, semiColonPos);
        String password = basicAuthDecoded.substring(semiColonPos + 1);
        return new String[]{login, password};
    }

    private static String getDecodedBasicAuth(String basicAuthEncoded) {
        try {
            return new String(BASE64_DECODER.decode(basicAuthEncoded.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC)).setMessage("Invalid basic header").build();
        }
    }

    private UserDto authenticate(String login, String password, HttpServletRequest request) {
        if (StringUtils.isEmpty((String)password)) {
            UserDto userDto = this.authenticateFromUserToken(login);
            this.authenticationEvent.loginSuccess(request, userDto.getLogin(), AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC_TOKEN));
            return userDto;
        }
        return this.credentialsAuthenticator.authenticate(login, password, request, AuthenticationEvent.Method.BASIC);
    }

    private UserDto authenticateFromUserToken(String token) {
        Optional<String> authenticatedUserUuid = this.userTokenAuthenticator.authenticate(token);
        if (!authenticatedUserUuid.isPresent()) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC_TOKEN)).setMessage("Token doesn't exist").build();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.dbClient.userDao().selectByUuid(dbSession, authenticatedUserUuid.get());
            if (userDto == null || !userDto.isActive()) {
                throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC_TOKEN)).setMessage("User doesn't exist").build();
            }
            UserDto userDto2 = userDto;
            return userDto2;
        }
    }
}

