/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.Strings;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CeTaskSubmit {
    private final String uuid;
    private final String type;
    private final String componentUuid;
    private final String submitterUuid;

    private CeTaskSubmit(Builder builder) {
        this.uuid = Objects.requireNonNull(Strings.emptyToNull((String)builder.uuid));
        this.type = Objects.requireNonNull(Strings.emptyToNull((String)builder.type));
        this.componentUuid = Strings.emptyToNull((String)builder.componentUuid);
        this.submitterUuid = Strings.emptyToNull((String)builder.submitterUuid);
    }

    public String getType() {
        return this.type;
    }

    public String getUuid() {
        return this.uuid;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.componentUuid;
    }

    @CheckForNull
    public String getSubmitterUuid() {
        return this.submitterUuid;
    }

    public static final class Builder {
        private final String uuid;
        private String type;
        private String componentUuid;
        private String submitterUuid;

        public Builder(String uuid) {
            this.uuid = uuid;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Builder setType(String s) {
            this.type = s;
            return this;
        }

        public Builder setComponentUuid(@Nullable String s) {
            this.componentUuid = s;
            return this;
        }

        public Builder setSubmitterUuid(@Nullable String s) {
            this.submitterUuid = s;
            return this;
        }

        public CeTaskSubmit build() {
            return new CeTaskSubmit(this);
        }
    }
}

