/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;

public class LanguageParamUtils {
    private LanguageParamUtils() {
    }

    public static String getExampleValue(Languages languages) {
        Language[] languageArray = languages.all();
        if (languageArray.length > 0) {
            return languageArray[0].getKey();
        }
        return "";
    }

    public static Collection<String> getLanguageKeys(Languages languages) {
        return Collections2.transform(Arrays.asList(languages.all()), (Function)LanguageToKeyFunction.INSTANCE);
    }

    private static enum LanguageToKeyFunction implements Function<Language, String>
    {
        INSTANCE;


        public String apply(@Nonnull Language input) {
            return input.getKey();
        }
    }
}

