/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import com.google.protobuf.Message;
import java.util.Date;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.usertoken.ws.TokenPermissionsValidator;
import org.sonar.server.usertoken.ws.UserTokensWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUserTokens;
import org.sonarqube.ws.client.usertoken.SearchWsRequest;

public class SearchAction
implements UserTokensWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;

    public SearchAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("List the access tokens of a user.<br>The login must exist and active.<br>If the login is set, it requires administration permissions. Otherwise, a token is generated for the authenticated user.").setResponseExample(this.getClass().getResource("search-example.json")).setSince("5.3").setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login").setExampleValue((Object)"g.hopper");
    }

    public void handle(Request request, Response response) throws Exception {
        WsUserTokens.SearchWsResponse searchWsResponse = this.doHandle(this.toSearchWsRequest(request));
        WsUtils.writeProtobuf((Message)searchWsResponse, request, response);
    }

    private WsUserTokens.SearchWsResponse doHandle(SearchWsRequest request) {
        TokenPermissionsValidator.validate(this.userSession, request.getLogin());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String login = request.getLogin();
            this.checkLoginExists(dbSession, login);
            List userTokens = this.dbClient.userTokenDao().selectByLogin(dbSession, login);
            WsUserTokens.SearchWsResponse searchWsResponse = SearchAction.buildResponse(login, userTokens);
            return searchWsResponse;
        }
    }

    private SearchWsRequest toSearchWsRequest(Request request) {
        SearchWsRequest searchWsRequest = new SearchWsRequest().setLogin(request.param("login"));
        if (searchWsRequest.getLogin() == null) {
            searchWsRequest.setLogin(this.userSession.getLogin());
        }
        return searchWsRequest;
    }

    private static WsUserTokens.SearchWsResponse buildResponse(String login, List<UserTokenDto> userTokensDto) {
        WsUserTokens.SearchWsResponse.Builder searchWsResponse = WsUserTokens.SearchWsResponse.newBuilder();
        WsUserTokens.SearchWsResponse.UserToken.Builder userTokenBuilder = WsUserTokens.SearchWsResponse.UserToken.newBuilder();
        searchWsResponse.setLogin(login);
        for (UserTokenDto userTokenDto : userTokensDto) {
            userTokenBuilder.clear().setName(userTokenDto.getName()).setCreatedAt(DateUtils.formatDateTime((Date)new Date(userTokenDto.getCreatedAt())));
            searchWsResponse.addUserTokens(userTokenBuilder);
        }
        return searchWsResponse.build();
    }

    private void checkLoginExists(DbSession dbSession, String login) {
        WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User with login '%s' not found", login);
    }
}

