/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.DefaultGroupFinder;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUserGroups;

public class SearchAction
implements UserGroupsWsAction {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_MEMBERS_COUNT = "membersCount";
    private static final List<String> ALL_FIELDS = Arrays.asList("name", "description", "membersCount");
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport groupWsSupport;
    private final DefaultGroupFinder defaultGroupFinder;

    public SearchAction(DbClient dbClient, UserSession userSession, GroupWsSupport groupWsSupport, DefaultGroupFinder defaultGroupFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.groupWsSupport = groupWsSupport;
        this.defaultGroupFinder = defaultGroupFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("Search for user groups.<br>Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("search-example.json")).setSince("5.2").addFieldsParam(ALL_FIELDS).addPagingParams(100, 500).addSearchQuery("sonar-users", new String[]{"names"}).setChangelog(new Change[]{new Change("6.4", "Paging response fields moved to a Paging object"), new Change("6.4", "'default' response field has been added")});
        action.createParam("organization").setDescription("Key of organization. If not set then groups are searched in default organization.").setExampleValue((Object)"my-org").setSince("6.2").setInternal(true);
    }

    public void handle(Request request, Response response) throws Exception {
        int page = request.mandatoryParamAsInt("p");
        int pageSize = request.mandatoryParamAsInt("ps");
        SearchOptions options = new SearchOptions().setPage(page, pageSize);
        String query = StringUtils.defaultIfBlank((String)request.param("q"), (String)"");
        Set<String> fields = SearchAction.neededFields(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.groupWsSupport.findOrganizationByKey(dbSession, request.param("organization"));
            this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER, organization);
            GroupDto defaultGroup = this.defaultGroupFinder.findDefaultGroup(dbSession, organization.getUuid());
            int limit = this.dbClient.groupDao().countByQuery(dbSession, organization.getUuid(), query);
            Paging paging = Paging.forPageIndex((int)page).withPageSize(pageSize).andTotal(limit);
            List groups = this.dbClient.groupDao().selectByQuery(dbSession, organization.getUuid(), query, options.getOffset(), pageSize);
            List groupIds = (List)groups.stream().map(GroupDto::getId).collect(MoreCollectors.toList((int)groups.size()));
            Map userCountByGroup = this.dbClient.groupMembershipDao().countUsersByGroups(dbSession, (Collection)groupIds);
            WsUtils.writeProtobuf((Message)SearchAction.buildResponse(groups, userCountByGroup, fields, paging, defaultGroup), request, response);
        }
    }

    private static Set<String> neededFields(Request request) {
        HashSet<String> fields = new HashSet<String>();
        List fieldsFromRequest = request.paramAsStrings("f");
        if (fieldsFromRequest == null || fieldsFromRequest.isEmpty()) {
            fields.addAll(ALL_FIELDS);
        } else {
            fields.addAll(fieldsFromRequest);
        }
        return fields;
    }

    private static WsUserGroups.SearchWsResponse buildResponse(List<GroupDto> groups, Map<String, Integer> userCountByGroup, Set<String> fields, Paging paging, GroupDto defaultGroup) {
        WsUserGroups.SearchWsResponse.Builder responseBuilder = WsUserGroups.SearchWsResponse.newBuilder();
        groups.forEach(group -> responseBuilder.addGroups(SearchAction.toWsGroup(group, (Integer)userCountByGroup.get(group.getName()), fields, defaultGroup.getId().equals(group.getId()))));
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        return responseBuilder.build();
    }

    private static WsUserGroups.Group toWsGroup(GroupDto group, Integer memberCount, Set<String> fields, boolean isDefault) {
        WsUserGroups.Group.Builder groupBuilder = WsUserGroups.Group.newBuilder().setId((long)group.getId().intValue()).setDefault(isDefault);
        if (fields.contains(FIELD_NAME)) {
            groupBuilder.setName(group.getName());
        }
        if (fields.contains(FIELD_DESCRIPTION)) {
            Protobuf.setNullable((Object)group.getDescription(), arg_0 -> ((WsUserGroups.Group.Builder)groupBuilder).setDescription(arg_0));
        }
        if (fields.contains(FIELD_MEMBERS_COUNT)) {
            groupBuilder.setMembersCount(memberCount.intValue());
        }
        return groupBuilder.build();
    }
}

