/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.property.PropertyQuery;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.user.ws.UserJsonWriter;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;

public class DeactivateAction
implements UsersWsAction {
    private static final String PARAM_LOGIN = "login";
    private final DbClient dbClient;
    private final UserIndexer userIndexer;
    private final UserSession userSession;
    private final UserJsonWriter userWriter;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public DeactivateAction(DbClient dbClient, UserIndexer userIndexer, UserSession userSession, UserJsonWriter userWriter, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userIndexer = userIndexer;
        this.userSession = userSession;
        this.userWriter = userWriter;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("deactivate").setDescription("Deactivate a user. Requires Administer System permission").setSince("3.7").setPost(true).setResponseExample(this.getClass().getResource("deactivate-example.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_LOGIN).setDescription("User login").setRequired(true).setExampleValue((Object)"myuser");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        String login = request.mandatoryParam(PARAM_LOGIN);
        WsUtils.checkRequest(!login.equals(this.userSession.getLogin()), "Self-deactivation is not possible", new Object[0]);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.dbClient.userDao().selectByLogin(dbSession, login);
            WsUtils.checkFound(user, "User '%s' doesn't exist", login);
            this.ensureNotLastAdministrator(dbSession, user);
            Integer userId = user.getId();
            this.dbClient.userTokenDao().deleteByLogin(dbSession, login);
            this.dbClient.propertiesDao().deleteByKeyAndValue(dbSession, "sonar.issues.defaultAssigneeLogin", user.getLogin());
            this.dbClient.propertiesDao().deleteByQuery(dbSession, PropertyQuery.builder().setUserId(userId).build());
            this.dbClient.userGroupDao().deleteByUserId(dbSession, userId.intValue());
            this.dbClient.userPermissionDao().deleteByUserId(dbSession, userId.intValue());
            this.dbClient.permissionTemplateDao().deleteUserPermissionsByUserId(dbSession, userId.intValue());
            this.dbClient.qProfileEditUsersDao().deleteByUser(dbSession, user);
            this.dbClient.organizationMemberDao().deleteByUserId(dbSession, userId.intValue());
            this.dbClient.userDao().deactivateUser(dbSession, user);
            this.userIndexer.commitAndIndex(dbSession, user);
        }
        this.writeResponse(response, login);
    }

    private void writeResponse(Response response, String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.dbClient.userDao().selectByLogin(dbSession, login);
            WsUtils.checkFound(user, "User '%s' doesn't exist", login);
            try (JsonWriter json = response.newJsonWriter();){
                json.beginObject();
                json.name("user");
                HashSet<String> groups = new HashSet<String>();
                groups.addAll(this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(login)).get((Object)login));
                this.userWriter.write(json, user, groups, UserJsonWriter.FIELDS);
                json.endObject();
            }
        }
    }

    private void ensureNotLastAdministrator(DbSession dbSession, UserDto user) {
        List<String> problematicOrgs = this.selectOrganizationsWithNoMoreAdministrators(dbSession, user);
        if (problematicOrgs.isEmpty()) {
            return;
        }
        WsUtils.checkRequest(problematicOrgs.size() != 1 || !this.defaultOrganizationProvider.get().getUuid().equals(problematicOrgs.get(0)), "User is last administrator, and cannot be deactivated", new Object[0]);
        String keys = problematicOrgs.stream().map(orgUuid -> this.selectOrganizationByUuid(dbSession, (String)orgUuid, user)).map(OrganizationDto::getKey).sorted().collect(Collectors.joining(", "));
        throw BadRequestException.create(String.format("User '%s' is last administrator of organizations [%s], and cannot be deactivated", user.getLogin(), keys));
    }

    private List<String> selectOrganizationsWithNoMoreAdministrators(DbSession dbSession, UserDto user) {
        Set organizationUuids = this.dbClient.authorizationDao().selectOrganizationUuidsOfUserWithGlobalPermission(dbSession, user.getId().intValue(), OrganizationPermission.ADMINISTER.getKey());
        ArrayList<String> problematicOrganizations = new ArrayList<String>();
        for (String organizationUuid : organizationUuids) {
            int remaining = this.dbClient.authorizationDao().countUsersWithGlobalPermissionExcludingUser(dbSession, organizationUuid, OrganizationPermission.ADMINISTER.getKey(), user.getId().intValue());
            if (remaining != 0) continue;
            problematicOrganizations.add(organizationUuid);
        }
        return problematicOrganizations;
    }

    private OrganizationDto selectOrganizationByUuid(DbSession dbSession, String orgUuid, UserDto user) {
        return (OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, orgUuid).orElseThrow(() -> new IllegalStateException("Organization with UUID " + orgUuid + " does not exist in DB but is referenced in permissions of user " + user.getLogin()));
    }
}

