/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.ExternalIdentity;
import org.sonar.server.user.NewUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUsers;
import org.sonarqube.ws.client.user.CreateRequest;

public class CreateAction
implements UsersWsAction {
    private final DbClient dbClient;
    private final UserUpdater userUpdater;
    private final UserSession userSession;

    public CreateAction(DbClient dbClient, UserUpdater userUpdater, UserSession userSession) {
        this.dbClient = dbClient;
        this.userUpdater = userUpdater;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setDescription("Create a user.<br/>If a deactivated user account exists with the given login, it will be reactivated.<br/>Requires Administer System permission").setSince("3.7").setChangelog(new Change[]{new Change("6.3", "The password is only mandatory when creating local users, and should not be set on non local users"), new Change("6.3", "The 'infos' message is no more returned when a user is reactivated")}).setPost(true).setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"myuser");
        action.createParam("password").setDescription("User password. Only mandatory when creating local user, otherwise it should not be set").setExampleValue((Object)"mypassword");
        action.createParam("name").setDescription("User name").setRequired(true).setExampleValue((Object)"My Name");
        action.createParam("email").setDescription("User email").setExampleValue((Object)"myname@email.com");
        action.createParam("scmAccounts").setDescription("This parameter is deprecated, please use '%s' instead", new Object[]{"scmAccount"}).setDeprecatedKey("scm_accounts", "6.0").setDeprecatedSince("6.1").setExampleValue((Object)"myscmaccount1,myscmaccount2");
        action.createParam("scmAccount").setDescription("SCM accounts. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"scmAccount=firstValue&scmAccount=secondValue&scmAccount=thirdValue");
        action.createParam("local").setDescription("Specify if the user should be authenticated from SonarQube server or from an external authentication system. Password should not be set when local is set to false.").setSince("6.3").setDefaultValue((Object)"true").setBooleanPossibleValues();
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        WsUtils.writeProtobuf((Message)this.doHandle(CreateAction.toWsRequest(request)), request, response);
    }

    private WsUsers.CreateWsResponse doHandle(CreateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            NewUser.Builder newUser = NewUser.builder().setLogin(request.getLogin()).setName(request.getName()).setEmail(request.getEmail()).setScmAccounts(request.getScmAccounts()).setPassword(request.getPassword());
            if (!request.isLocal()) {
                newUser.setExternalIdentity(new ExternalIdentity("sonarqube", request.getLogin()));
            }
            UserDto createdUser = this.userUpdater.createAndCommit(dbSession, newUser.build(), u -> {});
            WsUsers.CreateWsResponse createWsResponse = CreateAction.buildResponse(createdUser);
            return createWsResponse;
        }
    }

    private static WsUsers.CreateWsResponse buildResponse(UserDto userDto) {
        WsUsers.CreateWsResponse.User.Builder userBuilder = WsUsers.CreateWsResponse.User.newBuilder().setLogin(userDto.getLogin()).setName(userDto.getName()).setActive(userDto.isActive()).setLocal(userDto.isLocal()).addAllScmAccounts((Iterable)userDto.getScmAccountsAsList());
        Protobuf.setNullable((Object)Strings.emptyToNull((String)userDto.getEmail()), arg_0 -> ((WsUsers.CreateWsResponse.User.Builder)userBuilder).setEmail(arg_0));
        return WsUsers.CreateWsResponse.newBuilder().setUser(userBuilder).build();
    }

    private static CreateRequest toWsRequest(Request request) {
        return CreateRequest.builder().setLogin(request.mandatoryParam("login")).setPassword(request.param("password")).setName(request.param("name")).setEmail(request.param("email")).setScmAccounts(CreateAction.getScmAccounts(request)).setLocal(request.mandatoryParamAsBoolean("local")).build();
    }

    private static List<String> getScmAccounts(Request request) {
        if (request.hasParam("scmAccount")) {
            return request.multiParam("scmAccount");
        }
        List<String> oldScmAccounts = request.paramAsStrings("scmAccounts");
        return oldScmAccounts != null ? oldScmAccounts : Collections.emptyList();
    }
}

