/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.SearchResult;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndexDefinition;
import org.sonar.server.user.index.UserQuery;

@ServerSide
@ComputeEngineSide
public class UserIndex {
    private final EsClient esClient;
    private final System2 system2;

    public UserIndex(EsClient esClient, System2 system2) {
        this.esClient = esClient;
        this.system2 = system2;
    }

    @CheckForNull
    public UserDoc getNullableByLogin(String login) {
        GetRequestBuilder request = this.esClient.prepareGet(UserIndexDefinition.INDEX_TYPE_USER, login).setFetchSource(true).setRouting(login);
        GetResponse response = (GetResponse)request.get();
        if (response.isExists()) {
            return new UserDoc(response.getSource());
        }
        return null;
    }

    public List<UserDoc> getAtMostThreeActiveUsersForScmAccount(String scmAccount) {
        ArrayList<UserDoc> result = new ArrayList<UserDoc>();
        if (!StringUtils.isEmpty((String)scmAccount)) {
            SearchRequestBuilder request = this.esClient.prepareSearch(UserIndexDefinition.INDEX_TYPE_USER).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"active", (boolean)true)).should((QueryBuilder)QueryBuilders.termQuery((String)"login", (String)scmAccount)).should((QueryBuilder)QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("email"), (Object)scmAccount)).should((QueryBuilder)QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("scmAccounts"), (Object)scmAccount)))).setSize(3);
            for (SearchHit hit : ((SearchResponse)request.get()).getHits().getHits()) {
                result.add(new UserDoc(hit.getSourceAsMap()));
            }
        }
        return result;
    }

    public SearchResult<UserDoc> search(UserQuery userQuery, SearchOptions options) {
        SearchRequestBuilder request = this.esClient.prepareSearch(UserIndexDefinition.INDEX_TYPE_USER).setSize(options.getLimit()).setFrom(options.getOffset()).addSort("name", SortOrder.ASC);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"active", (boolean)true));
        userQuery.getOrganizationUuid().ifPresent(o -> filter.must((QueryBuilder)QueryBuilders.termQuery((String)"organizationUuids", (String)o)));
        userQuery.getExcludedOrganizationUuid().ifPresent(o -> filter.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"organizationUuids", (String)o)));
        MatchAllQueryBuilder esQuery = QueryBuilders.matchAllQuery();
        Optional<String> textQuery = userQuery.getTextQuery();
        if (textQuery.isPresent()) {
            esQuery = QueryBuilders.multiMatchQuery((Object)textQuery.get(), (String[])new String[]{"login", DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER.subField("login"), "name", DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER.subField("name"), "email", DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER.subField("email")}).operator(Operator.AND);
        }
        request.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)esQuery).filter((QueryBuilder)filter));
        return new SearchResult<UserDoc>((SearchResponse)request.get(), UserDoc::new, this.system2.getDefaultTimeZone());
    }
}

