/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DBSessions;
import org.sonar.server.authentication.UserSessionInitializer;
import org.sonar.server.organization.DefaultOrganizationCache;
import org.sonar.server.platform.Platform;
import org.sonar.server.setting.ThreadLocalSettings;

public class UserSessionFilter
implements Filter {
    private static final Logger LOG = Loggers.get(UserSessionFilter.class);
    private final Platform platform;

    public UserSessionFilter() {
        this.platform = Platform.getInstance();
    }

    @VisibleForTesting
    UserSessionFilter(Platform platform) {
        this.platform = platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        DBSessions dbSessions = (DBSessions)this.platform.getContainer().getComponentByType(DBSessions.class);
        ThreadLocalSettings settings = (ThreadLocalSettings)((Object)this.platform.getContainer().getComponentByType(ThreadLocalSettings.class));
        DefaultOrganizationCache defaultOrganizationCache = (DefaultOrganizationCache)this.platform.getContainer().getComponentByType(DefaultOrganizationCache.class);
        UserSessionInitializer userSessionInitializer = (UserSessionInitializer)this.platform.getContainer().getComponentByType(UserSessionInitializer.class);
        LOG.trace("{} serves {}", (Object)Thread.currentThread(), (Object)request.getRequestURI());
        dbSessions.enableCaching();
        try {
            defaultOrganizationCache.load();
            try {
                settings.load();
                try {
                    UserSessionFilter.doFilter(request, response, chain, userSessionInitializer);
                }
                finally {
                    settings.unload();
                }
            }
            finally {
                defaultOrganizationCache.unload();
            }
        }
        finally {
            dbSessions.disableCaching();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain, @Nullable UserSessionInitializer userSessionInitializer) throws IOException, ServletException {
        try {
            if (userSessionInitializer == null || userSessionInitializer.initUserSession(request, response)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            if (userSessionInitializer != null) {
                userSessionInitializer.removeUserSession();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

