/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Strings;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonarqube.ws.Rules;

public class ListAction
implements RulesWsAction {
    private final DbClient dbClient;

    public ListAction(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("list").setDescription("List rules, excluding the manual rules and the rules with status REMOVED. JSON format is not supported for response.").setSince("5.2").setInternal(true).setResponseExample(this.getClass().getResource("list-example.txt")).setHandler((RequestHandler)this);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        Rules.ListResponse.Builder listResponseBuilder = Rules.ListResponse.newBuilder();
        Rules.ListResponse.Rule.Builder ruleBuilder = Rules.ListResponse.Rule.newBuilder();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.ruleDao().selectEnabled(dbSession, resultContext -> {
                RuleDefinitionDto dto = (RuleDefinitionDto)resultContext.getResultObject();
                ruleBuilder.clear().setRepository(dto.getRepositoryKey()).setKey(dto.getRuleKey()).setName(Strings.nullToEmpty((String)dto.getName())).setInternalKey(Strings.nullToEmpty((String)dto.getConfigKey()));
                listResponseBuilder.addRules(ruleBuilder.build());
            });
        }
        wsResponse.stream().setMediaType("application/x-protobuf");
        listResponseBuilder.build().writeTo(wsResponse.stream().output());
    }
}

