/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.user.UserSession;

public class AppAction
implements RulesWsAction {
    private final Languages languages;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final RuleWsSupport wsSupport;

    public AppAction(Languages languages, DbClient dbClient, UserSession userSession, RuleWsSupport wsSupport) {
        this.languages = languages;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("app").setDescription("Get data required for rendering the page 'Coding Rules'.").setResponseExample(this.getClass().getResource("app-example.json")).setSince("4.5").setInternal(true).setHandler((RequestHandler)this);
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setSince("6.4").setExampleValue((Object)"my-org");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, request.param("organization"));
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            this.addPermissions(organization, json);
            this.addLanguages(json);
            this.addRuleRepositories(json, dbSession);
            json.endObject().close();
        }
    }

    private void addPermissions(OrganizationDto organization, JsonWriter json) {
        boolean canWrite = this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, organization);
        json.prop("canWrite", canWrite);
    }

    private void addLanguages(JsonWriter json) {
        json.name("languages").beginObject();
        for (Language language : this.languages.all()) {
            json.prop(language.getKey(), language.getName());
        }
        json.endObject();
    }

    private void addRuleRepositories(JsonWriter json, DbSession dbSession) {
        json.name("repositories").beginArray();
        this.dbClient.ruleRepositoryDao().selectAll(dbSession).forEach(r -> json.beginObject().prop("key", r.getKey()).prop("name", r.getName()).prop("language", r.getLanguage()).endObject());
        json.endArray();
    }
}

