/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.db.organization.OrganizationDto;

public class RuleUpdate {
    private final RuleKey ruleKey;
    private boolean changeTags = false;
    private boolean changeMarkdownNote = false;
    private boolean changeDebtRemediationFunction = false;
    private boolean changeName = false;
    private boolean changeDescription = false;
    private boolean changeSeverity = false;
    private boolean changeStatus = false;
    private boolean changeParameters = false;
    private final RuleUpdateUseCase useCase;
    private Set<String> tags;
    private String markdownNote;
    private DebtRemediationFunction debtRemediationFunction;
    private String name;
    private String markdownDescription;
    private String severity;
    private RuleStatus status;
    private final Map<String, String> parameters = Maps.newHashMap();
    private OrganizationDto organization;

    private RuleUpdate(RuleKey ruleKey, RuleUpdateUseCase useCase) {
        this.ruleKey = ruleKey;
        this.useCase = useCase;
    }

    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    @CheckForNull
    public Set<String> getTags() {
        return this.tags;
    }

    public RuleUpdate setTags(@Nullable Set<String> tags) {
        this.tags = tags;
        this.changeTags = true;
        return this;
    }

    @CheckForNull
    public String getMarkdownNote() {
        return this.markdownNote;
    }

    public RuleUpdate setMarkdownNote(@Nullable String s) {
        this.markdownNote = s == null ? null : StringUtils.defaultIfBlank((String)s, null);
        this.changeMarkdownNote = true;
        return this;
    }

    @CheckForNull
    public DebtRemediationFunction getDebtRemediationFunction() {
        return this.debtRemediationFunction;
    }

    public RuleUpdate setDebtRemediationFunction(@Nullable DebtRemediationFunction fn) {
        this.debtRemediationFunction = fn;
        this.changeDebtRemediationFunction = true;
        return this;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    public RuleUpdate setName(@Nullable String name) {
        this.checkCustomRule();
        this.name = name;
        this.changeName = true;
        return this;
    }

    @CheckForNull
    public String getMarkdownDescription() {
        return this.markdownDescription;
    }

    public RuleUpdate setMarkdownDescription(@Nullable String markdownDescription) {
        this.checkCustomRule();
        this.markdownDescription = markdownDescription;
        this.changeDescription = true;
        return this;
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    public RuleUpdate setSeverity(@Nullable String severity) {
        this.checkCustomRule();
        this.severity = severity;
        this.changeSeverity = true;
        return this;
    }

    @CheckForNull
    public RuleStatus getStatus() {
        return this.status;
    }

    public RuleUpdate setStatus(@Nullable RuleStatus status) {
        this.checkCustomRule();
        this.status = status;
        this.changeStatus = true;
        return this;
    }

    public RuleUpdate setParameters(Map<String, String> params) {
        this.checkCustomRule();
        this.parameters.clear();
        this.parameters.putAll(params);
        this.changeParameters = true;
        return this;
    }

    public RuleUpdate setOrganization(OrganizationDto organization) {
        this.organization = organization;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @CheckForNull
    public String parameter(String paramKey) {
        return this.parameters.get(paramKey);
    }

    boolean isCustomRule() {
        return this.useCase.isCustomRule;
    }

    public boolean isChangeTags() {
        return this.changeTags;
    }

    public boolean isChangeMarkdownNote() {
        return this.changeMarkdownNote;
    }

    public boolean isChangeDebtRemediationFunction() {
        return this.changeDebtRemediationFunction;
    }

    public boolean isChangeName() {
        return this.changeName;
    }

    public boolean isChangeDescription() {
        return this.changeDescription;
    }

    public boolean isChangeSeverity() {
        return this.changeSeverity;
    }

    public boolean isChangeStatus() {
        return this.changeStatus;
    }

    public boolean isChangeParameters() {
        return this.changeParameters;
    }

    public boolean isEmpty() {
        return !this.changeMarkdownNote && !this.changeTags && !this.changeDebtRemediationFunction && this.isCustomRuleFieldsEmpty();
    }

    private boolean isCustomRuleFieldsEmpty() {
        return !this.changeName && !this.changeDescription && !this.changeSeverity && !this.changeStatus && !this.changeParameters;
    }

    private void checkCustomRule() {
        if (this.useCase != RuleUpdateUseCase.CUSTOM_RULE) {
            throw new IllegalStateException("Not a custom rule");
        }
    }

    public OrganizationDto getOrganization() {
        return this.organization;
    }

    public static RuleUpdate createForPluginRule(RuleKey ruleKey) {
        return new RuleUpdate(ruleKey, RuleUpdateUseCase.PLUGIN_RULE);
    }

    public static RuleUpdate createForCustomRule(RuleKey ruleKey) {
        return new RuleUpdate(ruleKey, RuleUpdateUseCase.CUSTOM_RULE);
    }

    public static enum RuleUpdateUseCase {
        PLUGIN_RULE(false),
        CUSTOM_RULE(true);

        public final boolean isCustomRule;

        private RuleUpdateUseCase(boolean isCustomRule) {
            this.isCustomRule = isCustomRule;
        }
    }
}

