/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.protobuf.Message;
import java.io.InputStream;
import org.sonar.api.profiles.ProfileImporter;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QProfileExporters;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.qualityprofile.QProfileName;
import org.sonar.server.qualityprofile.QProfileResult;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.LanguageParamUtils;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.QualityProfiles;
import org.sonarqube.ws.client.qualityprofile.CreateRequest;

public class CreateAction
implements QProfileWsAction {
    private static final String PARAM_BACKUP_FORMAT = "backup_%s";
    private final DbClient dbClient;
    private final QProfileFactory profileFactory;
    private final QProfileExporters exporters;
    private final Languages languages;
    private final ProfileImporter[] importers;
    private final QProfileWsSupport qProfileWsSupport;
    private final UserSession userSession;
    private final ActiveRuleIndexer activeRuleIndexer;

    public CreateAction(DbClient dbClient, QProfileFactory profileFactory, QProfileExporters exporters, Languages languages, QProfileWsSupport qProfileWsSupport, UserSession userSession, ActiveRuleIndexer activeRuleIndexer, ProfileImporter ... importers) {
        this.dbClient = dbClient;
        this.profileFactory = profileFactory;
        this.exporters = exporters;
        this.languages = languages;
        this.qProfileWsSupport = qProfileWsSupport;
        this.userSession = userSession;
        this.activeRuleIndexer = activeRuleIndexer;
        this.importers = importers;
    }

    public CreateAction(DbClient dbClient, QProfileFactory profileFactory, QProfileExporters exporters, Languages languages, QProfileWsSupport qProfileWsSupport, UserSession userSession, ActiveRuleIndexer activeRuleIndexer) {
        this(dbClient, profileFactory, exporters, languages, qProfileWsSupport, userSession, activeRuleIndexer, new ProfileImporter[0]);
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction create = controller.createAction("create").setSince("5.2").setDescription("Create a quality profile.<br>Requires to be logged in and the 'Administer Quality Profiles' permission.").setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setHandler((RequestHandler)this);
        QProfileWsSupport.createOrganizationParam(create).setSince("6.4");
        create.createParam("name").setDescription("Quality profile name").setExampleValue((Object)"My Sonar way").setDeprecatedKey("profileName", "6.6").setRequired(true);
        create.createParam("language").setDescription("Quality profile language").setExampleValue((Object)"js").setPossibleValues(LanguageParamUtils.getLanguageKeys(this.languages)).setRequired(true);
        for (ProfileImporter importer : this.importers) {
            create.createParam(CreateAction.getBackupParamName(importer.getKey())).setDescription(String.format("A configuration file for %s.", importer.getName()));
        }
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.qProfileWsSupport.getOrganizationByKey(dbSession, request.param("organization"));
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, organization);
            CreateRequest createRequest = CreateAction.toRequest(request, organization);
            WsUtils.writeProtobuf((Message)this.doHandle(dbSession, createRequest, request, organization), request, response);
        }
    }

    private QualityProfiles.CreateWsResponse doHandle(DbSession dbSession, CreateRequest createRequest, Request request, OrganizationDto organization) {
        QProfileResult result = new QProfileResult();
        QProfileDto profile = this.profileFactory.checkAndCreateCustom(dbSession, organization, QProfileName.createFor(createRequest.getLanguage(), createRequest.getName()));
        result.setProfile(profile);
        for (ProfileImporter importer : this.importers) {
            String importerKey = importer.getKey();
            InputStream contentToImport = request.paramAsInputStream(CreateAction.getBackupParamName(importerKey));
            if (contentToImport == null) continue;
            result.add(this.exporters.importXml(profile, importerKey, contentToImport, dbSession));
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, result.getChanges());
        return this.buildResponse(result, organization);
    }

    private static CreateRequest toRequest(Request request, OrganizationDto organization) {
        CreateRequest.Builder builder = CreateRequest.builder().setOrganizationKey(organization.getKey()).setLanguage(request.mandatoryParam("language")).setName(request.mandatoryParam("name"));
        return builder.build();
    }

    private QualityProfiles.CreateWsResponse buildResponse(QProfileResult result, OrganizationDto organization) {
        String language = result.profile().getLanguage();
        QualityProfiles.CreateWsResponse.QualityProfile.Builder builder = QualityProfiles.CreateWsResponse.QualityProfile.newBuilder().setOrganization(organization.getKey()).setKey(result.profile().getKee()).setName(result.profile().getName()).setLanguage(language).setLanguageName(this.languages.get(result.profile().getLanguage()).getName()).setIsDefault(false).setIsInherited(false);
        if (!result.infos().isEmpty()) {
            builder.getInfosBuilder().addAllInfos(result.infos());
        }
        if (!result.warnings().isEmpty()) {
            builder.getWarningsBuilder().addAllWarnings(result.warnings());
        }
        return QualityProfiles.CreateWsResponse.newBuilder().setProfile(builder.build()).build();
    }

    private static String getBackupParamName(String importerKey) {
        return String.format(PARAM_BACKUP_FORMAT, importerKey);
    }
}

