/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.ws.WsUtils;

public class QualityGatesWsSupport {
    private final DbClient dbClient;
    private final DefaultOrganizationProvider organizationProvider;

    public QualityGatesWsSupport(DbClient dbClient, DefaultOrganizationProvider organizationProvider) {
        this.dbClient = dbClient;
        this.organizationProvider = organizationProvider;
    }

    QualityGateConditionDto getCondition(DbSession dbSession, long id) {
        return WsUtils.checkFound(this.dbClient.gateConditionDao().selectById(id, dbSession), "No quality gate condition with id '%d'", id);
    }

    OrganizationDto getOrganization(DbSession dbSession) {
        String organizationKey = this.organizationProvider.get().getKey();
        return (OrganizationDto)this.dbClient.organizationDao().selectByKey(dbSession, organizationKey).orElseThrow(() -> new NotFoundException(String.format("No organization with key '%s'", organizationKey)));
    }
}

