/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.MeasureQuery;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualitygate.ws.QualityGateDetailsFormatter;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsQualityGates;
import org.sonarqube.ws.client.qualitygate.ProjectStatusWsRequest;

public class ProjectStatusAction
implements QualityGatesWsAction {
    private static final String QG_STATUSES_ONE_LINE = Arrays.stream(WsQualityGates.ProjectStatusWsResponse.Status.values()).map(Enum::toString).collect(Collectors.joining(", "));
    private static final String MSG_ONE_PARAMETER_ONLY = String.format("Either '%s', '%s' or '%s' must be provided", "analysisId", "projectId", "projectKey");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public ProjectStatusAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("project_status").setDescription(String.format("Get the quality gate status of a project or a Compute Engine task.<br />" + MSG_ONE_PARAMETER_ONLY + "<br />The different statuses returned are: %s. The %s status is returned when there is no quality gate associated with the analysis.<br />Returns an HTTP code 404 if the analysis associated with the task is not found or does not exist.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li><li>'Browse' on the specified project</li></ul>", QG_STATUSES_ONE_LINE, WsQualityGates.ProjectStatusWsResponse.Status.NONE)).setResponseExample(this.getClass().getResource("project_status-example.json")).setSince("5.3").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.4", "The field 'ignoredConditions' is added to the response")});
        action.createParam("analysisId").setDescription("Analysis id").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL1");
        action.createParam("projectId").setSince("5.4").setDescription("Project id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setSince("5.4").setDescription("Project key").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        WsQualityGates.ProjectStatusWsResponse projectStatusWsResponse = this.doHandle(ProjectStatusAction.toProjectStatusWsRequest(request));
        WsUtils.writeProtobuf((Message)projectStatusWsResponse, request, response);
    }

    private WsQualityGates.ProjectStatusWsResponse doHandle(ProjectStatusWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ProjectAndSnapshot projectAndSnapshot = this.getProjectAndSnapshot(dbSession, request);
            this.checkPermission(projectAndSnapshot.project);
            com.google.common.base.Optional<String> measureData = this.getQualityGateDetailsMeasureData(dbSession, projectAndSnapshot.project);
            WsQualityGates.ProjectStatusWsResponse projectStatusWsResponse = WsQualityGates.ProjectStatusWsResponse.newBuilder().setProjectStatus(new QualityGateDetailsFormatter(measureData, (com.google.common.base.Optional<SnapshotDto>)projectAndSnapshot.snapshotDto).format()).build();
            return projectStatusWsResponse;
        }
    }

    private ProjectAndSnapshot getProjectAndSnapshot(DbSession dbSession, ProjectStatusWsRequest request) {
        String analysisUuid = request.getAnalysisId();
        if (!Strings.isNullOrEmpty((String)request.getAnalysisId())) {
            return this.getSnapshotThenProject(dbSession, analysisUuid);
        }
        if (!Strings.isNullOrEmpty((String)request.getProjectId()) ^ !Strings.isNullOrEmpty((String)request.getProjectKey())) {
            return this.getProjectThenSnapshot(dbSession, request);
        }
        throw BadRequestException.create(MSG_ONE_PARAMETER_ONLY);
    }

    private ProjectAndSnapshot getProjectThenSnapshot(DbSession dbSession, ProjectStatusWsRequest request) {
        ComponentDto projectDto = this.componentFinder.getByUuidOrKey(dbSession, request.getProjectId(), request.getProjectKey(), ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
        Optional snapshot = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, projectDto.projectUuid());
        return new ProjectAndSnapshot(projectDto, snapshot.orElse(null));
    }

    private ProjectAndSnapshot getSnapshotThenProject(DbSession dbSession, String analysisUuid) {
        SnapshotDto snapshotDto = this.getSnapshot(dbSession, analysisUuid);
        ComponentDto projectDto = this.dbClient.componentDao().selectOrFailByUuid(dbSession, snapshotDto.getComponentUuid());
        return new ProjectAndSnapshot(projectDto, snapshotDto);
    }

    private SnapshotDto getSnapshot(DbSession dbSession, String analysisUuid) {
        Optional snapshotDto = this.dbClient.snapshotDao().selectByUuid(dbSession, analysisUuid);
        return (SnapshotDto)WsUtils.checkFoundWithOptional(snapshotDto, "Analysis with id '%s' is not found", analysisUuid);
    }

    private com.google.common.base.Optional<String> getQualityGateDetailsMeasureData(DbSession dbSession, ComponentDto project) {
        MeasureQuery measureQuery = MeasureQuery.builder().setProjectUuids(Collections.singletonList(project.projectUuid())).setMetricKey("quality_gate_details").build();
        List measures = this.dbClient.measureDao().selectByQuery(dbSession, measureQuery);
        return measures.isEmpty() ? com.google.common.base.Optional.absent() : com.google.common.base.Optional.fromNullable((Object)((MeasureDto)measures.get(0)).getData());
    }

    private static ProjectStatusWsRequest toProjectStatusWsRequest(Request request) {
        ProjectStatusWsRequest projectStatusWsRequest = new ProjectStatusWsRequest().setAnalysisId(request.param("analysisId")).setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey"));
        WsUtils.checkRequest(!Strings.isNullOrEmpty((String)projectStatusWsRequest.getAnalysisId()) ^ !Strings.isNullOrEmpty((String)projectStatusWsRequest.getProjectId()) ^ !Strings.isNullOrEmpty((String)projectStatusWsRequest.getProjectKey()), MSG_ONE_PARAMETER_ONLY, new Object[0]);
        return projectStatusWsRequest;
    }

    private void checkPermission(ComponentDto project) {
        if (!this.userSession.hasComponentPermission("admin", project) && !this.userSession.hasComponentPermission("user", project)) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }

    private static class ProjectAndSnapshot {
        private final ComponentDto project;
        private final com.google.common.base.Optional<SnapshotDto> snapshotDto;

        private ProjectAndSnapshot(ComponentDto project, @Nullable SnapshotDto snapshotDto) {
            this.project = project;
            this.snapshotDto = com.google.common.base.Optional.fromNullable((Object)snapshotDto);
        }
    }
}

