/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import org.picocontainer.Startable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.loadedtemplate.LoadedTemplateDao;
import org.sonar.db.loadedtemplate.LoadedTemplateDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.RatingGrid;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;
import org.sonar.server.qualitygate.QualityGateUpdater;
import org.sonar.server.qualitygate.QualityGates;

public class RegisterQualityGates
implements Startable {
    private static final String BUILTIN_QUALITY_GATE = "SonarQube way";
    private static final int LEAK_PERIOD = 1;
    private final DbClient dbClient;
    private final QualityGateUpdater qualityGateUpdater;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final LoadedTemplateDao loadedTemplateDao;
    private final QualityGates qualityGates;

    public RegisterQualityGates(DbClient dbClient, QualityGateUpdater qualityGateUpdater, QualityGateConditionsUpdater qualityGateConditionsUpdater, LoadedTemplateDao loadedTemplateDao, QualityGates qualityGates) {
        this.dbClient = dbClient;
        this.qualityGateUpdater = qualityGateUpdater;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.loadedTemplateDao = loadedTemplateDao;
        this.qualityGates = qualityGates;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (this.shouldRegisterBuiltinQualityGate(dbSession)) {
                this.createBuiltinQualityGate(dbSession);
                this.registerBuiltinQualityGate(dbSession);
                dbSession.commit();
            }
        }
    }

    public void stop() {
    }

    private boolean shouldRegisterBuiltinQualityGate(DbSession dbSession) {
        return this.loadedTemplateDao.countByTypeAndKey("QUALITY_GATE", BUILTIN_QUALITY_GATE, dbSession) == 0;
    }

    private void createBuiltinQualityGate(DbSession dbSession) {
        String ratingAValue = Integer.toString(RatingGrid.Rating.A.getIndex());
        QualityGateDto builtin = this.qualityGateUpdater.create(dbSession, BUILTIN_QUALITY_GATE);
        this.qualityGateConditionsUpdater.createCondition(dbSession, builtin.getId(), "new_security_rating", "GT", null, ratingAValue, 1);
        this.qualityGateConditionsUpdater.createCondition(dbSession, builtin.getId(), "new_reliability_rating", "GT", null, ratingAValue, 1);
        this.qualityGateConditionsUpdater.createCondition(dbSession, builtin.getId(), "new_maintainability_rating", "GT", null, ratingAValue, 1);
        this.qualityGateConditionsUpdater.createCondition(dbSession, builtin.getId(), "new_coverage", "LT", null, "80", 1);
        this.qualityGateConditionsUpdater.createCondition(dbSession, builtin.getId(), "new_duplicated_lines_density", "GT", null, "3", 1);
        this.qualityGates.setDefault(dbSession, builtin.getId());
    }

    private void registerBuiltinQualityGate(DbSession dbSession) {
        this.loadedTemplateDao.insert(new LoadedTemplateDto(BUILTIN_QUALITY_GATE, "QUALITY_GATE"), dbSession);
    }
}

