/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Consumer;
import org.sonar.db.event.EventDto;
import org.sonarqube.ws.client.projectanalysis.EventCategory;

class EventValidator {
    private static final Set<String> AUTHORIZED_CATEGORIES = ImmutableSet.of((Object)EventCategory.VERSION.name(), (Object)EventCategory.OTHER.name());
    private static final String AUTHORIZED_CATEGORIES_INLINED = Joiner.on((String)", ").join(AUTHORIZED_CATEGORIES);

    private EventValidator() {
    }

    static Consumer<EventDto> checkModifiable() {
        return event -> Preconditions.checkArgument((boolean)AUTHORIZED_CATEGORIES.contains(EventCategory.fromLabel((String)event.getCategory()).name()), (String)"Event of category '%s' cannot be modified. Authorized categories: %s", (Object[])new Object[]{EventCategory.fromLabel((String)event.getCategory()), AUTHORIZED_CATEGORIES_INLINED});
    }
}

