/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.projectanalysis.ws.ProjectAnalysesWsAction;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.projectanalysis.DeleteRequest;

public class DeleteAction
implements ProjectAnalysesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setDescription("Delete a project analysis.<br>Requires one of the following permissions:<ul>  <li>'Administer System'</li>  <li>'Administer' rights on the project of the specified analysis</li></ul>").setSince("6.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("analysis").setDescription("Analysis key").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL1").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        Stream.of(request).map(DeleteAction.toWsRequest()).forEach(this.deleteAnalysis());
        response.noContent();
    }

    private static Function<Request, DeleteRequest> toWsRequest() {
        return request -> new DeleteRequest(request.mandatoryParam("analysis"));
    }

    private Consumer<DeleteRequest> deleteAnalysis() {
        return request -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                SnapshotDto analysis = (SnapshotDto)this.dbClient.snapshotDao().selectByUuid(dbSession, request.getAnalysis()).orElseThrow(() -> DeleteAction.analysisNotFoundException(request.getAnalysis()));
                if ("U".equals(analysis.getStatus())) {
                    throw DeleteAction.analysisNotFoundException(request.getAnalysis());
                }
                this.userSession.checkComponentUuidPermission("admin", analysis.getComponentUuid());
                Preconditions.checkArgument((analysis.getLast() == false ? 1 : 0) != 0, (String)"The last analysis '%s' cannot be deleted", (Object[])new Object[]{request.getAnalysis()});
                analysis.setStatus("U");
                this.dbClient.snapshotDao().update(dbSession, analysis);
                dbSession.commit();
            }
        };
    }

    private static NotFoundException analysisNotFoundException(String analysis) {
        return new NotFoundException(String.format("Analysis '%s' not found", analysis));
    }
}

