/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.PluginRepository;
import org.sonar.server.platform.Platform;
import org.sonarqube.ws.MediaTypes;

public class StaticResourcesServlet
extends HttpServlet {
    private static final Logger LOG = Loggers.get(StaticResourcesServlet.class);
    private static final long serialVersionUID = -2577454614650178426L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            ServletOutputStream out;
            InputStream in;
            block9: {
                PluginRepository pluginRepository;
                String resource;
                String pluginKey;
                block8: {
                    pluginKey = this.getPluginKey(request);
                    resource = this.getResourcePath(request);
                    in = null;
                    out = null;
                    pluginRepository = (PluginRepository)this.getContainer().getComponentByType(PluginRepository.class);
                    if (pluginRepository.hasPlugin(pluginKey)) break block8;
                    StaticResourcesServlet.silentlySendError(response, 404);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    return;
                }
                try {
                    in = pluginRepository.getPluginInstance(pluginKey).getClass().getClassLoader().getResourceAsStream(resource);
                    if (in != null) {
                        this.completeContentType(response, resource);
                        out = response.getOutputStream();
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        break block9;
                    }
                    StaticResourcesServlet.silentlySendError(response, 404);
                }
                catch (ClientAbortException e) {
                    LOG.trace("Client canceled loading resource [{}] from plugin [{}]: {}", new Object[]{resource, pluginKey, e});
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(out);
                    break block10;
                }
                catch (Exception e2) {
                    LOG.error(String.format("Unable to load resource [%s] from plugin [%s]", resource, pluginKey), (Throwable)e2);
                    StaticResourcesServlet.silentlySendError(response, 500);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(out);
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @VisibleForTesting
    protected ComponentContainer getContainer() {
        return Platform.getInstance().getContainer();
    }

    private static void silentlySendError(HttpServletResponse response, int error) {
        if (response.isCommitted()) {
            LOG.trace("Response is committed. Cannot send error response code {}", (Object)error);
            return;
        }
        try {
            response.sendError(error);
        }
        catch (IOException e) {
            LOG.trace("Failed to send error code {}: {}", (Object)error, (Object)e);
        }
    }

    private static String getPluginKeyAndResourcePath(HttpServletRequest request) {
        return StringUtils.substringAfter((String)request.getRequestURI(), (String)(request.getContextPath() + request.getServletPath() + "/"));
    }

    @VisibleForTesting
    protected String getPluginKey(HttpServletRequest request) {
        return StringUtils.substringBefore((String)StaticResourcesServlet.getPluginKeyAndResourcePath(request), (String)"/");
    }

    protected String getResourcePath(HttpServletRequest request) {
        return "static/" + StringUtils.substringAfter((String)StaticResourcesServlet.getPluginKeyAndResourcePath(request), (String)"/");
    }

    @VisibleForTesting
    void completeContentType(HttpServletResponse response, String filename) {
        response.setContentType(MediaTypes.getByFilename((String)filename));
    }
}

