/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web.requestid;

import java.util.Base64;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.sonar.core.util.UuidGenerator;
import org.sonar.server.platform.web.requestid.RequestIdConfiguration;
import org.sonar.server.platform.web.requestid.RequestIdGenerator;
import org.sonar.server.platform.web.requestid.RequestIdGeneratorBase;

public class RequestIdGeneratorImpl
implements RequestIdGenerator {
    public static final long UUID_GENERATOR_RENEWAL_COUNT = 0x400000L;
    private final AtomicLong counter = new AtomicLong();
    private final RequestIdGeneratorBase requestIdGeneratorBase;
    private final RequestIdConfiguration requestIdConfiguration;
    private final AtomicReference<UuidGenerator.WithFixedBase> uuidGenerator;

    public RequestIdGeneratorImpl(RequestIdGeneratorBase requestIdGeneratorBase, RequestIdConfiguration requestIdConfiguration) {
        this.requestIdGeneratorBase = requestIdGeneratorBase;
        this.uuidGenerator = new AtomicReference<UuidGenerator.WithFixedBase>(requestIdGeneratorBase.createNew());
        this.requestIdConfiguration = requestIdConfiguration;
    }

    @Override
    public String generate() {
        UuidGenerator.WithFixedBase currentUuidGenerator = this.uuidGenerator.get();
        long counterValue = this.counter.getAndIncrement();
        if (counterValue != 0L && this.mustRenewUuidGenerator(counterValue)) {
            UuidGenerator.WithFixedBase newUuidGenerator = this.requestIdGeneratorBase.createNew();
            this.uuidGenerator.set(newUuidGenerator);
            return RequestIdGeneratorImpl.generate(newUuidGenerator, counterValue);
        }
        return RequestIdGeneratorImpl.generate(currentUuidGenerator, counterValue);
    }

    private boolean mustRenewUuidGenerator(long counter) {
        return counter % this.requestIdConfiguration.getUidGeneratorRenewalCount() == 0L;
    }

    private static String generate(UuidGenerator.WithFixedBase uuidGenerator, long increment) {
        return Base64.getEncoder().encodeToString(uuidGenerator.generate((int)increment));
    }
}

