/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import org.sonar.api.server.ServerSide;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.updatecenter.common.Version;

@ServerSide
public class PluginsSection
implements SystemInfoSection {
    private final PluginRepository repository;

    public PluginsSection(PluginRepository repository) {
        this.repository = repository;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Plugins");
        for (PluginInfo plugin : this.repository.getPluginInfos()) {
            String label = "[" + plugin.getName() + "]";
            Version version = plugin.getVersion();
            if (version != null) {
                label = version.getName() + " " + label;
            }
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)plugin.getKey(), (String)label);
        }
        return protobuf.build();
    }
}

