/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.util.Optional;
import org.picocontainer.Startable;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.db.migration.version.DatabaseVersion;

public class DatabaseServerCompatibility
implements Startable {
    private static final String HIGHLIGHTER = "################################################################################";
    private DatabaseVersion version;

    public DatabaseServerCompatibility(DatabaseVersion version) {
        this.version = version;
    }

    public void start() {
        DatabaseVersion.Status status = this.version.getStatus();
        if (status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
            throw MessageException.of((String)"Database was upgraded to a more recent of SonarQube. Backup must probably be restored or db settings are incorrect.");
        }
        if (status == DatabaseVersion.Status.REQUIRES_UPGRADE) {
            Optional currentVersion = this.version.getVersion();
            if (currentVersion.isPresent() && (Long)currentVersion.get() < 1152L) {
                throw MessageException.of((String)"Current version is too old. Please upgrade to Long Term Support version firstly.");
            }
            String msg = "Database must be upgraded. Please backup database and browse /setup";
            Loggers.get(DatabaseServerCompatibility.class).warn(msg);
            Loggers.get((String)"startup").warn("\n################################################################################\n      " + msg + '\n' + HIGHLIGHTER);
        }
    }

    public void stop() {
    }
}

