/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.permission.index.AuthorizationScope;
import org.sonar.server.permission.index.NeedAuthorizationIndexer;
import org.sonar.server.permission.index.PermissionIndexerDao;

public class PermissionIndexer
implements ProjectIndexer {
    private final DbClient dbClient;
    private final EsClient esClient;
    private final Collection<AuthorizationScope> authorizationScopes;
    private final Set<IndexType> indexTypes;

    public PermissionIndexer(DbClient dbClient, EsClient esClient, NeedAuthorizationIndexer ... needAuthorizationIndexers) {
        this(dbClient, esClient, (Collection)Arrays.stream(needAuthorizationIndexers).map(NeedAuthorizationIndexer::getAuthorizationScope).collect(MoreCollectors.toList((int)needAuthorizationIndexers.length)));
    }

    @VisibleForTesting
    public PermissionIndexer(DbClient dbClient, EsClient esClient, Collection<AuthorizationScope> authorizationScopes) {
        this.dbClient = dbClient;
        this.esClient = esClient;
        this.authorizationScopes = authorizationScopes;
        this.indexTypes = (Set)authorizationScopes.stream().map(AuthorizationScope::getIndexType).collect(MoreCollectors.toSet((int)authorizationScopes.size()));
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return this.indexTypes;
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        List<PermissionIndexerDao.Dto> authorizations = this.getAllAuthorizations();
        Stream<AuthorizationScope> scopes = this.getScopes(uninitializedIndexTypes);
        this.index(authorizations, scopes, BulkIndexer.Size.LARGE);
    }

    @VisibleForTesting
    void index(List<PermissionIndexerDao.Dto> authorizations) {
        this.index(authorizations, this.authorizationScopes.stream(), BulkIndexer.Size.REGULAR);
    }

    @Override
    public void indexOnAnalysis(String branchUuid) {
    }

    @Override
    public Collection<EsQueueDto> prepareForRecovery(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        switch (cause) {
            case PROJECT_KEY_UPDATE: 
            case PROJECT_TAGS_UPDATE: {
                return Collections.emptyList();
            }
            case PROJECT_CREATION: 
            case PROJECT_DELETION: 
            case PERMISSION_CHANGE: {
                return this.insertIntoEsQueue(dbSession, projectUuids);
            }
        }
        throw new IllegalStateException("Unsupported cause: " + (Object)((Object)cause));
    }

    private Collection<EsQueueDto> insertIntoEsQueue(DbSession dbSession, Collection<String> projectUuids) {
        List items = (List)this.indexTypes.stream().flatMap(indexType -> projectUuids.stream().map(projectUuid -> EsQueueDto.create((String)indexType.format(), (String)projectUuid, null, (String)projectUuid))).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        return items;
    }

    private void index(Collection<PermissionIndexerDao.Dto> authorizations, Stream<AuthorizationScope> scopes, BulkIndexer.Size bulkSize) {
        if (authorizations.isEmpty()) {
            return;
        }
        scopes.forEach(scope -> {
            IndexType indexType = scope.getIndexType();
            BulkIndexer bulkIndexer = new BulkIndexer(this.esClient, indexType, bulkSize);
            bulkIndexer.start();
            authorizations.stream().filter(scope.getProjectPredicate()).map(dto -> PermissionIndexer.newIndexRequest(dto, indexType)).forEach(bulkIndexer::add);
            bulkIndexer.stop();
        });
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        IndexingResult result = new IndexingResult();
        List<BulkIndexer> bulkIndexers = items.stream().map(EsQueueDto::getDocType).distinct().map(IndexType::parse).filter(this.indexTypes::contains).map(indexType -> new BulkIndexer(this.esClient, (IndexType)indexType, BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items))).collect(Collectors.toList());
        if (bulkIndexers.isEmpty()) {
            return result;
        }
        bulkIndexers.forEach(BulkIndexer::start);
        PermissionIndexerDao permissionIndexerDao = new PermissionIndexerDao();
        Set remainingProjectUuids = (Set)items.stream().map(EsQueueDto::getDocId).collect(MoreCollectors.toHashSet());
        permissionIndexerDao.selectByUuids(this.dbClient, dbSession, remainingProjectUuids).forEach(p -> {
            remainingProjectUuids.remove(p.getProjectUuid());
            bulkIndexers.forEach(bi -> bi.add(PermissionIndexer.newIndexRequest(p, bi.getIndexType())));
        });
        remainingProjectUuids.forEach(projectUuid -> bulkIndexers.forEach(bi -> bi.addDeletion(bi.getIndexType(), (String)projectUuid, (String)projectUuid)));
        bulkIndexers.forEach(b -> result.add(b.stop()));
        return result;
    }

    private static IndexRequest newIndexRequest(PermissionIndexerDao.Dto dto, IndexType indexType) {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        if (dto.isAllowAnyone()) {
            doc.put("allowAnyone", true);
        } else {
            doc.put("allowAnyone", false);
            doc.put("groupIds", dto.getGroupIds());
            doc.put("userIds", dto.getUserIds());
        }
        return new IndexRequest(indexType.getIndex(), indexType.getType()).id(dto.getProjectUuid()).routing(dto.getProjectUuid()).source(doc);
    }

    private Stream<AuthorizationScope> getScopes(Set<IndexType> indexTypes) {
        return this.authorizationScopes.stream().filter(scope -> indexTypes.contains(scope.getIndexType()));
    }

    private List<PermissionIndexerDao.Dto> getAllAuthorizations() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<PermissionIndexerDao.Dto> list = new PermissionIndexerDao().selectAll(this.dbClient, dbSession);
            return list;
        }
    }
}

