/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.es.IndexType;
import org.sonar.server.permission.index.AuthorizationTypeSupport;
import org.sonar.server.permission.index.PermissionIndexerDao;

@Immutable
public final class AuthorizationScope {
    private final IndexType indexType;
    private final Predicate<PermissionIndexerDao.Dto> projectPredicate;

    public AuthorizationScope(IndexType indexType, Predicate<PermissionIndexerDao.Dto> projectPredicate) {
        this.indexType = AuthorizationTypeSupport.getAuthorizationIndexType(indexType);
        this.projectPredicate = Objects.requireNonNull(projectPredicate);
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public Predicate<PermissionIndexerDao.Dto> getProjectPredicate() {
        return this.projectPredicate;
    }
}

