/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.List;
import java.util.Optional;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.UserPermissionDto;
import org.sonar.server.permission.PermissionChange;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.UserPermissionChange;
import org.sonar.server.ws.WsUtils;

public class UserPermissionChanger {
    private final DbClient dbClient;

    public UserPermissionChanger(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public boolean apply(DbSession dbSession, UserPermissionChange change) {
        UserPermissionChanger.ensureConsistencyWithVisibility(change);
        if (UserPermissionChanger.isImplicitlyAlreadyDone(change)) {
            return false;
        }
        switch (change.getOperation()) {
            case ADD: {
                return this.addPermission(dbSession, change);
            }
            case REMOVE: {
                return this.removePermission(dbSession, change);
            }
        }
        throw new UnsupportedOperationException("Unsupported permission change: " + (Object)((Object)change.getOperation()));
    }

    private static boolean isImplicitlyAlreadyDone(UserPermissionChange change) {
        return change.getProjectId().map(projectId -> UserPermissionChanger.isImplicitlyAlreadyDone(projectId, change)).orElse(false);
    }

    private static boolean isImplicitlyAlreadyDone(ProjectId projectId, UserPermissionChange change) {
        return UserPermissionChanger.isAttemptToAddPublicPermissionToPublicComponent(change, projectId);
    }

    private static boolean isAttemptToAddPublicPermissionToPublicComponent(UserPermissionChange change, ProjectId projectId) {
        return !projectId.isPrivate() && change.getOperation() == PermissionChange.Operation.ADD && ProjectPermissions.PUBLIC_PERMISSIONS.contains(change.getPermission());
    }

    private static void ensureConsistencyWithVisibility(UserPermissionChange change) {
        change.getProjectId().ifPresent(projectId -> WsUtils.checkRequest(!UserPermissionChanger.isAttemptToRemovePublicPermissionFromPublicComponent(change, projectId), "Permission %s can't be removed from a public component", change.getPermission()));
    }

    private static boolean isAttemptToRemovePublicPermissionFromPublicComponent(UserPermissionChange change, ProjectId projectId) {
        return !projectId.isPrivate() && change.getOperation() == PermissionChange.Operation.REMOVE && ProjectPermissions.PUBLIC_PERMISSIONS.contains(change.getPermission());
    }

    private boolean addPermission(DbSession dbSession, UserPermissionChange change) {
        if (this.loadExistingPermissions(dbSession, change).contains(change.getPermission())) {
            return false;
        }
        UserPermissionDto dto = new UserPermissionDto(change.getOrganizationUuid(), change.getPermission(), change.getUserId().getId(), change.getNullableProjectId());
        this.dbClient.userPermissionDao().insert(dbSession, dto);
        return true;
    }

    private boolean removePermission(DbSession dbSession, UserPermissionChange change) {
        if (!this.loadExistingPermissions(dbSession, change).contains(change.getPermission())) {
            return false;
        }
        this.checkOtherAdminsExist(dbSession, change);
        Optional<ProjectId> projectId = change.getProjectId();
        if (projectId.isPresent()) {
            this.dbClient.userPermissionDao().deleteProjectPermission(dbSession, change.getUserId().getId(), change.getPermission(), projectId.get().getId());
        } else {
            this.dbClient.userPermissionDao().deleteGlobalPermission(dbSession, change.getUserId().getId(), change.getPermission(), change.getOrganizationUuid());
        }
        return true;
    }

    private List<String> loadExistingPermissions(DbSession dbSession, UserPermissionChange change) {
        Optional<ProjectId> projectId = change.getProjectId();
        if (projectId.isPresent()) {
            return this.dbClient.userPermissionDao().selectProjectPermissionsOfUser(dbSession, change.getUserId().getId(), projectId.get().getId());
        }
        return this.dbClient.userPermissionDao().selectGlobalPermissionsOfUser(dbSession, change.getUserId().getId(), change.getOrganizationUuid());
    }

    private void checkOtherAdminsExist(DbSession dbSession, UserPermissionChange change) {
        if ("admin".equals(change.getPermission()) && !change.getProjectId().isPresent()) {
            int remaining = this.dbClient.authorizationDao().countUsersWithGlobalPermissionExcludingUserPermission(dbSession, change.getOrganizationUuid(), change.getPermission(), change.getUserId().getId());
            WsUtils.checkRequest(remaining > 0, "Last user with permission '%s'. Permission cannot be removed.", "admin");
        }
    }
}

