/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.permission.GlobalPermissions;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.ws.WsUtils;

public abstract class PermissionChange {
    private final Operation operation;
    private final String organizationUuid;
    private final String permission;
    private final ProjectId projectId;

    public PermissionChange(Operation operation, String organizationUuid, String permission, @Nullable ProjectId projectId) {
        this.operation = Objects.requireNonNull(operation);
        this.organizationUuid = Objects.requireNonNull(organizationUuid);
        this.permission = Objects.requireNonNull(permission);
        this.projectId = projectId;
        if (projectId == null) {
            WsUtils.checkRequest(GlobalPermissions.ALL.contains(permission), "Invalid global permission '%s'. Valid values are %s", permission, GlobalPermissions.ALL);
        } else {
            WsUtils.checkRequest(ProjectPermissions.ALL.contains(permission), "Invalid project permission '%s'. Valid values are %s", permission, ProjectPermissions.ALL);
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String getPermission() {
        return this.permission;
    }

    public Optional<ProjectId> getProjectId() {
        return Optional.ofNullable(this.projectId);
    }

    @CheckForNull
    public String getProjectUuid() {
        return this.projectId == null ? null : this.projectId.getUuid();
    }

    @CheckForNull
    public Long getNullableProjectId() {
        return this.projectId == null ? null : Long.valueOf(this.projectId.getId());
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }
}

