/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentCleanerService;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.ws.WsUtils;

public class DeleteAction
implements OrganizationsWsAction {
    private static final String ACTION = "delete";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final ComponentCleanerService componentCleanerService;
    private final OrganizationFlags organizationFlags;
    private final UserIndexer userIndexer;
    private final QProfileFactory qProfileFactory;

    public DeleteAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, ComponentCleanerService componentCleanerService, OrganizationFlags organizationFlags, UserIndexer userIndexer, QProfileFactory qProfileFactory) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.componentCleanerService = componentCleanerService;
        this.organizationFlags = organizationFlags;
        this.userIndexer = userIndexer;
        this.qProfileFactory = qProfileFactory;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Delete an organization.<br/>Require 'Administer System' permission on the specified organization. Organization support must be enabled.").setInternal(true).setSince("6.2").setHandler((RequestHandler)this);
        action.createParam("organization").setRequired(true).setDescription("Organization key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"foo-company");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.organizationFlags.checkEnabled(dbSession);
            String key = request.mandatoryParam("organization");
            DeleteAction.preventDeletionOfDefaultOrganization(key, this.defaultOrganizationProvider.get());
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, key), "Organization with key '%s' not found", key);
            if (organization.isGuarded()) {
                this.userSession.checkIsSystemAdministrator();
            } else {
                this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            }
            this.deleteProjects(dbSession, organization);
            this.deletePermissions(dbSession, organization);
            this.deleteGroups(dbSession, organization);
            this.deleteQualityProfiles(dbSession, organization);
            this.deleteOrganization(dbSession, organization);
            response.noContent();
        }
    }

    private void deleteProjects(DbSession dbSession, OrganizationDto organization) {
        List roots = this.dbClient.componentDao().selectAllRootsByOrganization(dbSession, organization.getUuid());
        this.componentCleanerService.delete(dbSession, roots);
    }

    private void deletePermissions(DbSession dbSession, OrganizationDto organization) {
        this.dbClient.permissionTemplateDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
        this.dbClient.userPermissionDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
        this.dbClient.groupPermissionDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
    }

    private void deleteGroups(DbSession dbSession, OrganizationDto organization) {
        this.dbClient.groupDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
    }

    private void deleteQualityProfiles(DbSession dbSession, OrganizationDto organization) {
        List profiles = this.dbClient.qualityProfileDao().selectOrderedByOrganizationUuid(dbSession, organization);
        this.qProfileFactory.delete(dbSession, profiles);
    }

    private void deleteOrganization(DbSession dbSession, OrganizationDto organization) {
        List logins = this.dbClient.organizationMemberDao().selectLoginsByOrganizationUuid(dbSession, organization.getUuid());
        this.dbClient.organizationMemberDao().deleteByOrganizationUuid(dbSession, organization.getUuid());
        this.dbClient.organizationDao().deleteByUuid(dbSession, organization.getUuid());
        this.userIndexer.commitAndIndexByLogins(dbSession, logins);
    }

    private static void preventDeletionOfDefaultOrganization(String key, DefaultOrganization defaultOrganization) {
        Preconditions.checkArgument((!defaultOrganization.getKey().equals(key) ? 1 : 0) != 0, (Object)"Default Organization can't be deleted");
    }
}

