/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.collect.Multimap;
import java.util.Objects;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;

public interface NotificationManager {
    public void scheduleForSending(Notification var1);

    public Multimap<String, NotificationChannel> findSubscribedRecipientsForDispatcher(NotificationDispatcher var1, String var2, SubscriberPermissionsOnProject var3);

    public static final class SubscriberPermissionsOnProject {
        public static final SubscriberPermissionsOnProject ALL_MUST_HAVE_ROLE_USER = new SubscriberPermissionsOnProject("user");
        private final String globalSubscribers;
        private final String projectSubscribers;

        public SubscriberPermissionsOnProject(String globalAndProjectSubscribers) {
            this(globalAndProjectSubscribers, globalAndProjectSubscribers);
        }

        public SubscriberPermissionsOnProject(String globalSubscribers, String projectSubscribers) {
            this.globalSubscribers = Objects.requireNonNull(globalSubscribers, "global subscribers's required permission can't be null");
            this.projectSubscribers = Objects.requireNonNull(projectSubscribers, "project subscribers's required permission can't be null");
        }

        public String getGlobalSubscribers() {
            return this.globalSubscribers;
        }

        public String getProjectSubscribers() {
            return this.projectSubscribers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriberPermissionsOnProject that = (SubscriberPermissionsOnProject)o;
            return this.globalSubscribers.equals(that.globalSubscribers) && this.projectSubscribers.equals(that.projectSubscribers);
        }

        public int hashCode() {
            return Objects.hash(this.globalSubscribers, this.projectSubscribers);
        }
    }
}

