/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultContext;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.MeasureTreeQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.metric.MetricDtoFunctions;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.measure.ws.ComponentTreeAction;
import org.sonar.server.measure.ws.ComponentTreeData;
import org.sonar.server.measure.ws.ComponentTreeSort;
import org.sonar.server.measure.ws.HasMeasure;
import org.sonar.server.measure.ws.MetricDtoWithBestValue;
import org.sonar.server.measure.ws.SnapshotDtoToWsPeriods;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.measure.ComponentTreeWsRequest;

public class ComponentTreeDataLoader {
    private static final Set<String> QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE = ImmutableSet.of((Object)"FIL", (Object)"UTS");
    private static final Joiner COMA_JOINER = Joiner.on((String)", ");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final ResourceTypes resourceTypes;

    public ComponentTreeDataLoader(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, ResourceTypes resourceTypes) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.resourceTypes = resourceTypes;
    }

    ComponentTreeData load(ComponentTreeWsRequest wsRequest) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto baseComponent = this.loadComponent(dbSession, wsRequest);
            this.checkPermissions(baseComponent);
            Optional baseSnapshot = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, baseComponent.projectUuid());
            if (!baseSnapshot.isPresent()) {
                ComponentTreeData componentTreeData = ComponentTreeData.builder().setBaseComponent(baseComponent).build();
                return componentTreeData;
            }
            Long developerId = this.searchDeveloperId(dbSession, wsRequest);
            ComponentTreeQuery componentTreeQuery = this.toComponentTreeQuery(wsRequest, baseComponent);
            List<ComponentDto> components = this.searchComponents(dbSession, componentTreeQuery);
            List<MetricDto> metrics = this.searchMetrics(dbSession, wsRequest);
            Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric = this.searchMeasuresByComponentUuidAndMetric(dbSession, baseComponent, componentTreeQuery, components, metrics, developerId);
            components = ComponentTreeDataLoader.filterComponents(components, measuresByComponentUuidAndMetric, metrics, wsRequest);
            components = ComponentTreeDataLoader.sortComponents(components, wsRequest, metrics, measuresByComponentUuidAndMetric);
            int componentCount = components.size();
            components = ComponentTreeDataLoader.paginateComponents(components, wsRequest);
            ComponentTreeData componentTreeData = ComponentTreeData.builder().setBaseComponent(baseComponent).setComponentsFromDb(components).setComponentCount(componentCount).setMeasuresByComponentUuidAndMetric(measuresByComponentUuidAndMetric).setMetrics(metrics).setPeriods(SnapshotDtoToWsPeriods.snapshotToWsPeriods((SnapshotDto)baseSnapshot.get())).setReferenceComponentsByUuid(this.searchReferenceComponentsById(dbSession, components)).build();
            return componentTreeData;
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, ComponentTreeWsRequest request) {
        String componentKey = request.getComponent();
        String componentId = request.getBaseComponentId();
        String branch = request.getBranch();
        Preconditions.checkArgument((componentId == null || branch == null ? 1 : 0) != 0, (String)"'%s' and '%s' parameters cannot be used at the same time", (Object[])new Object[]{"baseComponentId", "branch"});
        return branch == null ? this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.BASE_COMPONENT_ID_AND_KEY) : this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
    }

    @CheckForNull
    private Long searchDeveloperId(DbSession dbSession, ComponentTreeWsRequest wsRequest) {
        if (wsRequest.getDeveloperId() == null && wsRequest.getDeveloperKey() == null) {
            return null;
        }
        return this.componentFinder.getByUuidOrKey(dbSession, wsRequest.getDeveloperId(), wsRequest.getDeveloperKey(), ComponentFinder.ParamNames.DEVELOPER_ID_AND_KEY).getId();
    }

    private Map<String, ComponentDto> searchReferenceComponentsById(DbSession dbSession, List<ComponentDto> components) {
        List referenceComponentUUids = (List)components.stream().map(ComponentDto::getCopyResourceUuid).filter(Objects::nonNull).collect(MoreCollectors.toList((int)components.size()));
        if (referenceComponentUUids.isEmpty()) {
            return Collections.emptyMap();
        }
        return FluentIterable.from((Iterable)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)referenceComponentUUids)).uniqueIndex(ComponentDto::uuid);
    }

    private List<ComponentDto> searchComponents(DbSession dbSession, ComponentTreeQuery componentTreeQuery) {
        Collection qualifiers = componentTreeQuery.getQualifiers();
        if (qualifiers != null && qualifiers.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dbClient.componentDao().selectDescendants(dbSession, componentTreeQuery);
    }

    private List<MetricDto> searchMetrics(DbSession dbSession, ComponentTreeWsRequest request) {
        List metricKeys = Objects.requireNonNull(request.getMetricKeys());
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, metricKeys);
        if (metrics.size() < metricKeys.size()) {
            List foundMetricKeys = Lists.transform((List)metrics, MetricDto::getKey);
            Sets.SetView missingMetricKeys = Sets.difference(new LinkedHashSet(metricKeys), new LinkedHashSet(foundMetricKeys));
            throw new NotFoundException(String.format("The following metric keys are not found: %s", COMA_JOINER.join((Iterable)missingMetricKeys)));
        }
        String forbiddenMetrics = (String)metrics.stream().filter(metric -> ComponentTreeAction.FORBIDDEN_METRIC_TYPES.contains(metric.getValueType())).map(MetricDto::getKey).sorted().collect(MoreCollectors.join((Joiner)COMA_JOINER));
        Preconditions.checkArgument((boolean)forbiddenMetrics.isEmpty(), (String)"Metrics %s can't be requested in this web service. Please use api/measures/component", (Object[])new Object[]{forbiddenMetrics});
        return metrics;
    }

    private Table<String, MetricDto, ComponentTreeData.Measure> searchMeasuresByComponentUuidAndMetric(DbSession dbSession, ComponentDto baseComponent, ComponentTreeQuery componentTreeQuery, List<ComponentDto> components, List<MetricDto> metrics, @Nullable Long developerId) {
        ImmutableMap metricsById = Maps.uniqueIndex(metrics, MetricDto::getId);
        MeasureTreeQuery measureQuery = MeasureTreeQuery.builder().setStrategy(MeasureTreeQuery.Strategy.valueOf((String)componentTreeQuery.getStrategy().name())).setNameOrKeyQuery(componentTreeQuery.getNameOrKeyQuery()).setQualifiers(componentTreeQuery.getQualifiers()).setPersonId(developerId).setMetricIds(new ArrayList(metricsById.keySet())).build();
        HashBasedTable measuresByComponentUuidAndMetric = HashBasedTable.create((int)components.size(), (int)metrics.size());
        this.dbClient.measureDao().selectTreeByQuery(dbSession, baseComponent, measureQuery, arg_0 -> ComponentTreeDataLoader.lambda$searchMeasuresByComponentUuidAndMetric$1((Table)measuresByComponentUuidAndMetric, (Map)metricsById, arg_0));
        ComponentTreeDataLoader.addBestValuesToMeasures((Table<String, MetricDto, ComponentTreeData.Measure>)measuresByComponentUuidAndMetric, components, metrics);
        return measuresByComponentUuidAndMetric;
    }

    private static void addBestValuesToMeasures(Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric, List<ComponentDto> components, List<MetricDto> metrics) {
        List metricDtosWithBestValueMeasure = (List)metrics.stream().filter(MetricDtoFunctions.isOptimizedForBestValue()).map(new MetricDtoToMetricDtoWithBestValue()).collect(MoreCollectors.toList((int)metrics.size()));
        if (metricDtosWithBestValueMeasure.isEmpty()) {
            return;
        }
        Stream<ComponentDto> componentsEligibleForBestValue = components.stream().filter(IsFileComponent.INSTANCE);
        componentsEligibleForBestValue.forEach(component -> {
            for (MetricDtoWithBestValue metricWithBestValue : metricDtosWithBestValueMeasure) {
                if (measuresByComponentUuidAndMetric.get((Object)component.uuid(), (Object)metricWithBestValue.getMetric()) != null) continue;
                measuresByComponentUuidAndMetric.put((Object)component.uuid(), (Object)metricWithBestValue.getMetric(), (Object)ComponentTreeData.Measure.createFromMeasureDto(metricWithBestValue.getBestValue()));
            }
        });
    }

    private static List<ComponentDto> filterComponents(List<ComponentDto> components, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric, List<MetricDto> metrics, ComponentTreeWsRequest wsRequest) {
        if (!ComponentTreeDataLoader.componentWithMeasuresOnly(wsRequest)) {
            return components;
        }
        String metricKeyToSort = wsRequest.getMetricSort();
        Optional<MetricDto> metricToSort = metrics.stream().filter(m -> metricKeyToSort.equals(m.getKey())).findFirst();
        Preconditions.checkState((boolean)metricToSort.isPresent(), (String)"Metric '%s' not found", (Object[])new Object[]{metricKeyToSort, wsRequest.getMetricKeys()});
        return (List)components.stream().filter(new HasMeasure(measuresByComponentUuidAndMetric, metricToSort.get(), wsRequest)).collect(MoreCollectors.toList((int)components.size()));
    }

    private static boolean componentWithMeasuresOnly(ComponentTreeWsRequest wsRequest) {
        return "withMeasuresOnly".equals(wsRequest.getMetricSortFilter());
    }

    private static List<ComponentDto> sortComponents(List<ComponentDto> components, ComponentTreeWsRequest wsRequest, List<MetricDto> metrics, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        return ComponentTreeSort.sortComponents(components, wsRequest, metrics, measuresByComponentUuidAndMetric);
    }

    private static List<ComponentDto> paginateComponents(List<ComponentDto> components, ComponentTreeWsRequest wsRequest) {
        return (List)components.stream().skip(Paging.offset((int)wsRequest.getPage(), (int)wsRequest.getPageSize())).limit(wsRequest.getPageSize().intValue()).collect(MoreCollectors.toList((int)wsRequest.getPageSize()));
    }

    @CheckForNull
    private List<String> childrenQualifiers(ComponentTreeWsRequest request, String baseQualifier) {
        List requestQualifiers = request.getQualifiers();
        List childrenQualifiers = null;
        if ("leaves".equals(request.getStrategy())) {
            childrenQualifiers = this.resourceTypes.getLeavesQualifiers(baseQualifier);
        }
        if (requestQualifiers == null) {
            return childrenQualifiers;
        }
        if (childrenQualifiers == null) {
            return requestQualifiers;
        }
        Sets.SetView qualifiersIntersection = Sets.intersection(new HashSet(childrenQualifiers), new HashSet(requestQualifiers));
        return new ArrayList<String>((Collection<String>)qualifiersIntersection);
    }

    private ComponentTreeQuery toComponentTreeQuery(ComponentTreeWsRequest wsRequest, ComponentDto baseComponent) {
        List<String> childrenQualifiers = this.childrenQualifiers(wsRequest, baseComponent.qualifier());
        ComponentTreeQuery.Builder componentTreeQueryBuilder = ComponentTreeQuery.builder().setBaseUuid(baseComponent.uuid()).setStrategy(ComponentTreeAction.STRATEGIES.get(wsRequest.getStrategy()));
        if (wsRequest.getQuery() != null) {
            componentTreeQueryBuilder.setNameOrKeyQuery(wsRequest.getQuery());
        }
        if (childrenQualifiers != null) {
            componentTreeQueryBuilder.setQualifiers(childrenQualifiers);
        }
        return componentTreeQueryBuilder.build();
    }

    private void checkPermissions(ComponentDto baseComponent) {
        this.userSession.checkComponentPermission("user", baseComponent);
    }

    private static /* synthetic */ void lambda$searchMeasuresByComponentUuidAndMetric$1(Table measuresByComponentUuidAndMetric, Map metricsById, ResultContext result) {
        MeasureDto measureDto = (MeasureDto)result.getResultObject();
        measuresByComponentUuidAndMetric.put((Object)measureDto.getComponentUuid(), metricsById.get(measureDto.getMetricId()), (Object)ComponentTreeData.Measure.createFromMeasureDto(measureDto));
    }

    private static class MetricDtoToMetricDtoWithBestValue
    implements Function<MetricDto, MetricDtoWithBestValue> {
        private MetricDtoToMetricDtoWithBestValue() {
        }

        @Override
        public MetricDtoWithBestValue apply(@Nonnull MetricDto input) {
            return new MetricDtoWithBestValue(input);
        }
    }

    private static enum IsFileComponent implements Predicate<ComponentDto>
    {
        INSTANCE;


        @Override
        public boolean test(@Nonnull ComponentDto input) {
            return QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE.contains(input.qualifier());
        }
    }
}

