/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.io.Resources;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.measure.custom.ws.CustomMeasureValidator;
import org.sonar.server.measure.custom.ws.CustomMeasuresWsAction;
import org.sonar.server.metric.ws.MetricJsonWriter;
import org.sonar.server.user.UserSession;

public class MetricsAction
implements CustomMeasuresWsAction {
    public static final String ACTION = "metrics";
    public static final String PARAM_PROJECT_ID = "projectId";
    public static final String PARAM_PROJECT_KEY = "projectKey";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public MetricsAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setSince("5.2").setInternal(true).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-metrics.json")).setDescription("List all custom metrics for which no custom measure already exists on a given project.<br /> The project id or project key must be provided.<br />Requires 'Administer System' permission or 'Administer' permission on the project.");
        action.createParam(PARAM_PROJECT_ID).setDescription("Project id").setExampleValue((Object)"ce4c03d6-430f-40a9-b777-ad877c00aa4d");
        action.createParam(PARAM_PROJECT_KEY).setDescription("Project key").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getByUuidOrKey(dbSession, request.param(PARAM_PROJECT_ID), request.param(PARAM_PROJECT_KEY), ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
            CustomMeasureValidator.checkPermissions(this.userSession, project);
            List<MetricDto> metrics = this.searchMetrics(dbSession, project);
            MetricsAction.writeResponse(response, metrics);
        }
    }

    private static void writeResponse(Response response, List<MetricDto> metrics) {
        JsonWriter json = response.newJsonWriter();
        json.beginObject();
        MetricJsonWriter.write(json, metrics, MetricJsonWriter.ALL_FIELDS);
        json.endObject();
        json.close();
    }

    private List<MetricDto> searchMetrics(DbSession dbSession, ComponentDto project) {
        return this.dbClient.metricDao().selectAvailableCustomMetricsByComponentUuid(dbSession, project.uuid());
    }
}

