/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.webhook;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.rules.RuleType;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.component.ComponentDto;

public interface IssueChangeWebhook {
    public void onChange(IssueChangeData var1, IssueChange var2, IssueChangeContext var3);

    public static final class IssueChangeData {
        private final List<DefaultIssue> issues;
        private final List<ComponentDto> components;

        public IssueChangeData(List<DefaultIssue> issues, List<ComponentDto> components) {
            this.issues = ImmutableList.copyOf(issues);
            this.components = ImmutableList.copyOf(components);
        }

        public List<DefaultIssue> getIssues() {
            return this.issues;
        }

        public List<ComponentDto> getComponents() {
            return this.components;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueChangeData that = (IssueChangeData)o;
            return Objects.equals(this.issues, that.issues) && Objects.equals(this.components, that.components);
        }

        public int hashCode() {
            return Objects.hash(this.issues, this.components);
        }

        public String toString() {
            return "IssueChangeData{issues=" + this.issues + ", components=" + this.components + '}';
        }
    }

    public static final class IssueChange {
        private final RuleType ruleType;
        private final String transitionKey;

        public IssueChange(RuleType ruleType) {
            this(ruleType, null);
        }

        public IssueChange(String transitionKey) {
            this(null, transitionKey);
        }

        public IssueChange(@Nullable RuleType ruleType, @Nullable String transitionKey) {
            Preconditions.checkArgument((ruleType != null || transitionKey != null ? 1 : 0) != 0, (Object)"At least one of ruleType and transitionKey must be non null");
            this.ruleType = ruleType;
            this.transitionKey = transitionKey;
        }

        public Optional<RuleType> getRuleType() {
            return Optional.ofNullable(this.ruleType);
        }

        public Optional<String> getTransitionKey() {
            return Optional.ofNullable(this.transitionKey);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueChange that = (IssueChange)o;
            return this.ruleType == that.ruleType && Objects.equals(this.transitionKey, that.transitionKey);
        }

        public int hashCode() {
            return Objects.hash(this.ruleType, this.transitionKey);
        }

        public String toString() {
            return "IssueChange{ruleType=" + this.ruleType + ", transitionKey='" + this.transitionKey + '\'' + '}';
        }
    }
}

