/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.get.MultiGetAction;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyMultiGetRequestBuilder
extends MultiGetRequestBuilder {
    public ProxyMultiGetRequestBuilder(Client client) {
        super((ElasticsearchClient)client, MultiGetAction.INSTANCE);
    }

    public MultiGetResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            MultiGetResponse multiGetResponse = (MultiGetResponse)super.execute().actionGet();
            return multiGetResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public MultiGetResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public MultiGetResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<MultiGetResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES multi get request");
        for (MultiGetRequest.Item item : (MultiGetRequest)this.request) {
            message.append(String.format(" [key '%s'", item.id()));
            message.append(String.format(", index '%s'", item.index()));
            String type = item.type();
            if (type != null) {
                message.append(String.format(", type '%s'", type));
            }
            message.append("],");
        }
        return message.toString();
    }
}

