/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyClusterHealthRequestBuilder
extends ClusterHealthRequestBuilder {
    public ProxyClusterHealthRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().cluster(), ClusterHealthAction.INSTANCE);
    }

    public ClusterHealthResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)super.execute().actionGet();
            return clusterHealthResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public ClusterHealthResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ClusterHealthResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<ClusterHealthResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES cluster health request");
        if (((ClusterHealthRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((ClusterHealthRequest)this.request).indices(), (String)",")));
        }
        return message.toString();
    }
}

