/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.sonar.server.es.IndexDefinitions;

class IndexDefinitionHash {
    private static final char DELIMITER = ',';

    private IndexDefinitionHash() {
    }

    static String of(IndexDefinitions.Index index) {
        return IndexDefinitionHash.of(index.getSettings().getAsMap(), index.getTypes());
    }

    private static String of(Map ... maps) {
        StringBuilder sb = new StringBuilder();
        for (Map map : maps) {
            IndexDefinitionHash.appendMap(sb, map);
        }
        return DigestUtils.sha256Hex((String)sb.toString());
    }

    private static void appendObject(StringBuilder sb, Object value) {
        if (value instanceof IndexDefinitions.IndexType) {
            IndexDefinitionHash.appendIndexType(sb, (IndexDefinitions.IndexType)value);
        } else if (value instanceof Map) {
            IndexDefinitionHash.appendMap(sb, (Map)value);
        } else if (value instanceof Iterable) {
            IndexDefinitionHash.appendIterable(sb, (Iterable)value);
        } else {
            sb.append(String.valueOf(value));
        }
    }

    private static void appendIndexType(StringBuilder sb, IndexDefinitions.IndexType type) {
        IndexDefinitionHash.appendMap(sb, type.getAttributes());
    }

    private static void appendMap(StringBuilder sb, Map attributes) {
        for (Map.Entry entry : IndexDefinitionHash.sort(attributes).entrySet()) {
            sb.append(entry.getKey());
            sb.append(',');
            IndexDefinitionHash.appendObject(sb, entry.getValue());
            sb.append(',');
        }
    }

    private static void appendIterable(StringBuilder sb, Iterable value) {
        ArrayList sorted = Lists.newArrayList((Iterable)value);
        Collections.sort(sorted);
        for (Object o : sorted) {
            IndexDefinitionHash.appendObject(sb, o);
            sb.append(',');
        }
    }

    private static SortedMap sort(Map map) {
        return ImmutableSortedMap.copyOf((Map)map);
    }
}

