/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.Collections;
import org.sonar.ce.queue.CeTask;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistScannerContextStep
implements ComputationStep {
    private final BatchReportReader reportReader;
    private final DbClient dbClient;
    private final CeTask ceTask;

    public PersistScannerContextStep(BatchReportReader reportReader, DbClient dbClient, CeTask ceTask) {
        this.reportReader = reportReader;
        this.dbClient = dbClient;
        this.ceTask = ceTask;
    }

    @Override
    public String getDescription() {
        return "Persist scanner context";
    }

    @Override
    public void execute() {
        block24: {
            try (CloseableIterator<String> logsIterator = this.reportReader.readScannerLogs();){
                if (!logsIterator.hasNext()) break block24;
                try (DbSession dbSession = this.dbClient.openSession(false);){
                    this.dbClient.ceScannerContextDao().deleteByUuids(dbSession, Collections.singleton(this.ceTask.getUuid()));
                    dbSession.commit();
                    this.dbClient.ceScannerContextDao().insert(dbSession, this.ceTask.getUuid(), logsIterator);
                    dbSession.commit();
                }
            }
        }
    }
}

