/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.FileSourceDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.server.computation.task.projectanalysis.source.ComputeFileSourceData;
import org.sonar.server.computation.task.projectanalysis.source.CoverageLineReader;
import org.sonar.server.computation.task.projectanalysis.source.DuplicationLineReader;
import org.sonar.server.computation.task.projectanalysis.source.HighlightingLineReader;
import org.sonar.server.computation.task.projectanalysis.source.LineReader;
import org.sonar.server.computation.task.projectanalysis.source.RangeOffsetConverter;
import org.sonar.server.computation.task.projectanalysis.source.ScmLineReader;
import org.sonar.server.computation.task.projectanalysis.source.SourceLinesRepository;
import org.sonar.server.computation.task.projectanalysis.source.SymbolsLineReader;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistFileSourcesStep
implements ComputationStep {
    private final DbClient dbClient;
    private final System2 system2;
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private final SourceLinesRepository sourceLinesRepository;
    private final ScmInfoRepository scmInfoRepository;
    private final DuplicationRepository duplicationRepository;

    public PersistFileSourcesStep(DbClient dbClient, System2 system2, TreeRootHolder treeRootHolder, BatchReportReader reportReader, SourceLinesRepository sourceLinesRepository, ScmInfoRepository scmInfoRepository, DuplicationRepository duplicationRepository) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
        this.sourceLinesRepository = sourceLinesRepository;
        this.scmInfoRepository = scmInfoRepository;
        this.duplicationRepository = duplicationRepository;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            new DepthTraversalTypeAwareCrawler(new FileSourceVisitor(dbSession)).visit(this.treeRootHolder.getRoot());
        }
    }

    @Override
    public String getDescription() {
        return "Persist sources";
    }

    private static class LineReaders
    implements AutoCloseable {
        private final List<LineReader> readers = new ArrayList<LineReader>();
        private final List<CloseableIterator<?>> closeables = new ArrayList();
        @CheckForNull
        private final ScmLineReader scmLineReader;

        LineReaders(BatchReportReader reportReader, ScmInfoRepository scmInfoRepository, DuplicationRepository duplicationRepository, Component component) {
            int componentRef = component.getReportAttributes().getRef();
            CloseableIterator<ScannerReport.LineCoverage> coverageIt = reportReader.readComponentCoverage(componentRef);
            this.closeables.add(coverageIt);
            this.readers.add(new CoverageLineReader((Iterator<ScannerReport.LineCoverage>)coverageIt));
            Optional<ScmInfo> scmInfoOptional = scmInfoRepository.getScmInfo(component);
            if (scmInfoOptional.isPresent()) {
                this.scmLineReader = new ScmLineReader((ScmInfo)scmInfoOptional.get());
                this.readers.add(this.scmLineReader);
            } else {
                this.scmLineReader = null;
            }
            RangeOffsetConverter rangeOffsetConverter = new RangeOffsetConverter();
            CloseableIterator<ScannerReport.SyntaxHighlightingRule> highlightingIt = reportReader.readComponentSyntaxHighlighting(componentRef);
            this.closeables.add(highlightingIt);
            this.readers.add(new HighlightingLineReader(component, (Iterator<ScannerReport.SyntaxHighlightingRule>)highlightingIt, rangeOffsetConverter));
            CloseableIterator<ScannerReport.Symbol> symbolsIt = reportReader.readComponentSymbols(componentRef);
            this.closeables.add(symbolsIt);
            this.readers.add(new SymbolsLineReader(component, (Iterator<ScannerReport.Symbol>)symbolsIt, rangeOffsetConverter));
            this.readers.add(new DuplicationLineReader(duplicationRepository.getDuplications(component)));
        }

        List<LineReader> readers() {
            return this.readers;
        }

        @Override
        public void close() {
            for (CloseableIterator<?> reportIterator : this.closeables) {
                reportIterator.close();
            }
        }

        @CheckForNull
        public Changeset getLatestChange() {
            if (this.scmLineReader == null) {
                return null;
            }
            return this.scmLineReader.getLatestChange();
        }
    }

    private class FileSourceVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private Map<String, FileSourceDto> previousFileSourcesByUuid;
        private String projectUuid;

        private FileSourceVisitor(DbSession session) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.previousFileSourcesByUuid = new HashMap<String, FileSourceDto>();
            this.session = session;
        }

        @Override
        public void visitProject(Component project) {
            this.projectUuid = project.getUuid();
            this.session.select("org.sonar.db.source.FileSourceMapper.selectHashesForProject", (Object)ImmutableMap.of((Object)"projectUuid", (Object)this.projectUuid, (Object)"dataType", (Object)"SOURCE"), context -> {
                FileSourceDto dto = (FileSourceDto)context.getResultObject();
                this.previousFileSourcesByUuid.put(dto.getFileUuid(), dto);
            });
        }

        @Override
        public void visitFile(Component file) {
            try (CloseableIterator<String> linesIterator = PersistFileSourcesStep.this.sourceLinesRepository.readLines(file);
                 LineReaders lineReaders = new LineReaders(PersistFileSourcesStep.this.reportReader, PersistFileSourcesStep.this.scmInfoRepository, PersistFileSourcesStep.this.duplicationRepository, file);){
                ComputeFileSourceData computeFileSourceData = new ComputeFileSourceData((Iterator<String>)linesIterator, lineReaders.readers(), file.getFileAttributes().getLines());
                ComputeFileSourceData.Data fileSourceData = computeFileSourceData.compute();
                this.persistSource(fileSourceData, file.getUuid(), lineReaders.getLatestChange());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Cannot persist sources of %s", file.getKey()), e);
            }
        }

        private void persistSource(ComputeFileSourceData.Data fileSourceData, String componentUuid, @Nullable Changeset latestChange) {
            DbFileSources.Data fileData = fileSourceData.getFileSourceData();
            byte[] data = FileSourceDto.encodeSourceData((DbFileSources.Data)fileData);
            String dataHash = DigestUtils.md5Hex((byte[])data);
            String srcHash = fileSourceData.getSrcHash();
            String lineHashes = fileSourceData.getLineHashes();
            FileSourceDto previousDto = this.previousFileSourcesByUuid.get(componentUuid);
            if (previousDto == null) {
                FileSourceDto dto = new FileSourceDto().setProjectUuid(this.projectUuid).setFileUuid(componentUuid).setDataType("SOURCE").setBinaryData(data).setSrcHash(srcHash).setDataHash(dataHash).setLineHashes(lineHashes).setCreatedAt(PersistFileSourcesStep.this.system2.now()).setUpdatedAt(PersistFileSourcesStep.this.system2.now()).setRevision(this.computeRevision(latestChange));
                PersistFileSourcesStep.this.dbClient.fileSourceDao().insert(this.session, dto);
                this.session.commit();
            } else {
                boolean revisionUpdated;
                boolean binaryDataUpdated = !dataHash.equals(previousDto.getDataHash());
                boolean srcHashUpdated = !srcHash.equals(previousDto.getSrcHash());
                String revision = this.computeRevision(latestChange);
                boolean bl = revisionUpdated = !ObjectUtils.equals((Object)revision, (Object)previousDto.getRevision());
                if (binaryDataUpdated || srcHashUpdated || revisionUpdated) {
                    previousDto.setBinaryData(data).setDataHash(dataHash).setSrcHash(srcHash).setLineHashes(lineHashes).setRevision(revision).setUpdatedAt(PersistFileSourcesStep.this.system2.now());
                    PersistFileSourcesStep.this.dbClient.fileSourceDao().update(this.session, previousDto);
                    this.session.commit();
                }
            }
        }

        @CheckForNull
        private String computeRevision(@Nullable Changeset latestChange) {
            if (latestChange == null) {
                return null;
            }
            return latestChange.getRevision();
        }
    }
}

