/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue.commonrule;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class DuplicatedBlockRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric duplicatedBlocksMetric;

    public DuplicatedBlockRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "DuplicatedBlocks");
        this.measureRepository = measureRepository;
        this.duplicatedBlocksMetric = metricRepository.getByKey("duplicated_blocks");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        Optional<Measure> duplicatedBlocksMeasure = this.measureRepository.getRawMeasure(file, this.duplicatedBlocksMetric);
        if (duplicatedBlocksMeasure.isPresent() && ((Measure)duplicatedBlocksMeasure.get()).getIntValue() > 0) {
            int duplicatedBlocks = ((Measure)duplicatedBlocksMeasure.get()).getIntValue();
            String message = String.format("%d duplicated blocks of code must be removed.", duplicatedBlocks);
            return new CommonRule.CommonRuleIssue(duplicatedBlocks, message);
        }
        return null;
    }
}

