/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;

public class IssueVisitors {
    private final IssueVisitor[] visitors;

    public IssueVisitors(IssueVisitor[] visitors) {
        this.visitors = visitors;
    }

    public void beforeComponent(Component component) {
        for (IssueVisitor visitor : this.visitors) {
            visitor.beforeComponent(component);
        }
    }

    public void onIssue(Component component, DefaultIssue issue) {
        for (IssueVisitor visitor : this.visitors) {
            visitor.onIssue(component, issue);
        }
    }

    public void afterComponent(Component component) {
        for (IssueVisitor visitor : this.visitors) {
            visitor.afterComponent(component);
        }
    }
}

