/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.ArrayList;
import java.util.Map;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.MergeBranchComponentUuids;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.issue.IssueCache;
import org.sonar.server.computation.task.projectanalysis.issue.IssueLifecycle;
import org.sonar.server.computation.task.projectanalysis.issue.IssueTrackingDelegator;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitors;
import org.sonar.server.computation.task.projectanalysis.issue.ShortBranchIssueMerger;
import org.sonar.server.computation.task.projectanalysis.issue.TrackingResult;
import org.sonar.server.util.cache.DiskCache;

public class IntegrateIssuesVisitor
extends TypeAwareVisitorAdapter {
    private final IssueCache issueCache;
    private final IssueLifecycle issueLifecycle;
    private final IssueVisitors issueVisitors;
    private final IssueTrackingDelegator issueTracking;
    private final ShortBranchIssueMerger issueStatusCopier;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MergeBranchComponentUuids mergeBranchComponentUuids;

    public IntegrateIssuesVisitor(IssueCache issueCache, IssueLifecycle issueLifecycle, IssueVisitors issueVisitors, AnalysisMetadataHolder analysisMetadataHolder, IssueTrackingDelegator issueTracking, ShortBranchIssueMerger issueStatusCopier, MergeBranchComponentUuids mergeBranchComponentUuids) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER);
        this.issueCache = issueCache;
        this.issueLifecycle = issueLifecycle;
        this.issueVisitors = issueVisitors;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.issueTracking = issueTracking;
        this.issueStatusCopier = issueStatusCopier;
        this.mergeBranchComponentUuids = mergeBranchComponentUuids;
    }

    @Override
    public void visitAny(Component component) {
        try (DiskCache.DiskAppender cacheAppender = this.issueCache.newAppender();){
            this.issueVisitors.beforeComponent(component);
            TrackingResult tracking = this.issueTracking.track(component);
            this.fillNewOpenIssues(component, tracking.newIssues(), cacheAppender);
            this.fillExistingOpenIssues(component, tracking.issuesToMerge(), cacheAppender);
            this.closeIssues(component, tracking.issuesToClose(), cacheAppender);
            this.copyIssues(component, tracking.issuesToCopy(), cacheAppender);
            this.issueVisitors.afterComponent(component);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to process issues of component '%s'", component.getKey()), e);
        }
    }

    private void fillNewOpenIssues(Component component, Iterable<DefaultIssue> newIssues, DiskCache.DiskAppender cacheAppender) {
        ArrayList<DefaultIssue> list = new ArrayList<DefaultIssue>();
        newIssues.forEach(issue -> {
            this.issueLifecycle.initNewOpenIssue((DefaultIssue)issue);
            list.add((DefaultIssue)issue);
        });
        if (list.isEmpty()) {
            return;
        }
        if (this.analysisMetadataHolder.isLongLivingBranch()) {
            this.issueStatusCopier.tryMerge(component, list);
        }
        for (DefaultIssue issue2 : list) {
            this.process(component, issue2, cacheAppender);
        }
    }

    private void copyIssues(Component component, Map<DefaultIssue, DefaultIssue> matched, DiskCache.DiskAppender cacheAppender) {
        for (Map.Entry<DefaultIssue, DefaultIssue> entry : matched.entrySet()) {
            DefaultIssue raw = entry.getKey();
            DefaultIssue base = entry.getValue();
            this.issueLifecycle.copyExistingOpenIssueFromLongLivingBranch(raw, base, this.mergeBranchComponentUuids.getMergeBranchName());
            this.process(component, raw, cacheAppender);
        }
    }

    private void fillExistingOpenIssues(Component component, Map<DefaultIssue, DefaultIssue> matched, DiskCache.DiskAppender cacheAppender) {
        for (Map.Entry<DefaultIssue, DefaultIssue> entry : matched.entrySet()) {
            DefaultIssue raw = entry.getKey();
            DefaultIssue base = entry.getValue();
            this.issueLifecycle.mergeExistingOpenIssue(raw, base);
            this.process(component, raw, cacheAppender);
        }
    }

    private void closeIssues(Component component, Iterable<DefaultIssue> issues, DiskCache.DiskAppender cacheAppender) {
        for (DefaultIssue issue : issues) {
            issue.setBeingClosed(true);
            this.process(component, issue, cacheAppender);
        }
    }

    private void process(Component component, DefaultIssue issue, DiskCache.DiskAppender cacheAppender) {
        this.issueLifecycle.doAutomaticTransition(issue);
        this.issueVisitors.onIssue(component, issue);
        cacheAppender.append(issue);
    }
}

