/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.queue;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ServerSide;
import org.sonar.ce.queue.CeQueue;
import org.sonar.ce.queue.CeTask;
import org.sonar.ce.queue.CeTaskSubmit;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeTaskCharacteristicDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentUpdater;
import org.sonar.server.component.NewComponent;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.permission.PermissionTemplateService;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;

@ServerSide
public class ReportSubmitter {
    private final CeQueue queue;
    private final UserSession userSession;
    private final ComponentUpdater componentUpdater;
    private final PermissionTemplateService permissionTemplateService;
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;

    public ReportSubmitter(CeQueue queue, UserSession userSession, ComponentUpdater componentUpdater, PermissionTemplateService permissionTemplateService, UuidFactory uuidFactory, DbClient dbClient) {
        this.queue = queue;
        this.userSession = userSession;
        this.componentUpdater = componentUpdater;
        this.permissionTemplateService = permissionTemplateService;
        this.uuidFactory = uuidFactory;
        this.dbClient = dbClient;
    }

    public CeTask submit(String organizationKey, String projectKey, @Nullable String projectBranch, @Nullable String projectName, InputStream reportInput) {
        return this.submit(organizationKey, projectKey, projectBranch, projectName, Collections.emptyMap(), reportInput);
    }

    public CeTask submit(String organizationKey, String projectKey, @Nullable String projectBranch, @Nullable String projectName, Map<String, String> characteristics, InputStream reportInput) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organizationDto = this.getOrganizationDtoOrFail(dbSession, organizationKey);
            String effectiveProjectKey = ComponentKeys.createKey((String)projectKey, (String)projectBranch);
            Optional component = this.dbClient.componentDao().selectByKey(dbSession, effectiveProjectKey);
            this.validateProject(dbSession, (Optional<ComponentDto>)component, projectKey);
            ReportSubmitter.ensureOrganizationIsConsistent((Optional<ComponentDto>)component, organizationDto);
            ComponentDto project = (ComponentDto)component.or(() -> this.createProject(dbSession, organizationDto, projectKey, projectBranch, projectName));
            this.checkScanPermission(project);
            CeTask ceTask = this.submitReport(dbSession, reportInput, project, characteristics);
            return ceTask;
        }
    }

    private void checkScanPermission(ComponentDto project) {
        if (!this.userSession.hasComponentPermission("scan", project) && !this.userSession.hasPermission(OrganizationPermission.SCAN, project.getOrganizationUuid())) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }

    private OrganizationDto getOrganizationDtoOrFail(DbSession dbSession, String organizationKey) {
        return (OrganizationDto)this.dbClient.organizationDao().selectByKey(dbSession, organizationKey).orElseThrow(() -> new NotFoundException(String.format("Organization with key '%s' does not exist", organizationKey)));
    }

    private void validateProject(DbSession dbSession, Optional<ComponentDto> project, String rawProjectKey) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!project.isPresent()) {
            return;
        }
        ComponentDto component = (ComponentDto)project.get();
        if (!"TRK".equals(component.qualifier()) || !"PRJ".equals(component.scope())) {
            errors.add(String.format("Component '%s' is not a project", rawProjectKey));
        }
        if (!((ComponentDto)project.get()).projectUuid().equals(((ComponentDto)project.get()).uuid())) {
            ComponentDto anotherBaseProject = this.dbClient.componentDao().selectOrFailByUuid(dbSession, ((ComponentDto)project.get()).projectUuid());
            errors.add(String.format("The project '%s' is already defined in SonarQube but as a module of project '%s'. If you really want to stop directly analysing project '%s', please first delete it from SonarQube and then relaunch the analysis of project '%s'.", rawProjectKey, anotherBaseProject.getKey(), anotherBaseProject.getKey(), rawProjectKey));
        }
        if (!errors.isEmpty()) {
            throw BadRequestException.create(errors);
        }
    }

    private static void ensureOrganizationIsConsistent(Optional<ComponentDto> project, OrganizationDto organizationDto) {
        if (project.isPresent()) {
            Preconditions.checkArgument((boolean)((ComponentDto)project.get()).getOrganizationUuid().equals(organizationDto.getUuid()), (String)"Organization of component with key '%s' does not match specified organization '%s'", (Object[])new Object[]{((ComponentDto)project.get()).getDbKey(), organizationDto.getKey()});
        }
    }

    private ComponentDto createProject(DbSession dbSession, OrganizationDto organization, String projectKey, @Nullable String deprecatedBranch, @Nullable String projectName) {
        this.userSession.checkPermission(OrganizationPermission.PROVISION_PROJECTS, organization);
        Integer userId = this.userSession.getUserId();
        String effectiveProjectKey = ComponentKeys.createEffectiveKey((String)projectKey, (String)deprecatedBranch);
        boolean wouldCurrentUserHaveScanPermission = this.permissionTemplateService.wouldUserHaveScanPermissionWithDefaultTemplate(dbSession, organization.getUuid(), userId, effectiveProjectKey, "TRK");
        if (!wouldCurrentUserHaveScanPermission) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        boolean newProjectPrivate = this.dbClient.organizationDao().getNewProjectPrivate(dbSession, organization);
        NewComponent newProject = NewComponent.newComponentBuilder().setOrganizationUuid(organization.getUuid()).setKey(projectKey).setName(StringUtils.defaultIfBlank((String)projectName, (String)projectKey)).setBranch(deprecatedBranch).setQualifier("TRK").setPrivate(newProjectPrivate).build();
        return this.componentUpdater.create(dbSession, newProject, userId);
    }

    private CeTask submitReport(DbSession dbSession, InputStream reportInput, ComponentDto project, Map<String, String> characteristicsMap) {
        CeTaskSubmit.Builder submit = this.queue.prepareSubmit();
        List characteristics = characteristicsMap.entrySet().stream().map(e -> this.toDto(submit.getUuid(), (String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        this.dbClient.ceTaskInputDao().insert(dbSession, submit.getUuid(), reportInput);
        if (!characteristics.isEmpty()) {
            this.dbClient.ceTaskCharacteristicsDao().insert(dbSession, characteristics);
        }
        dbSession.commit();
        submit.setType("REPORT");
        submit.setComponentUuid(project.uuid());
        submit.setSubmitterLogin(this.userSession.getLogin());
        return this.queue.submit(submit.build());
    }

    private CeTaskCharacteristicDto toDto(String taskUuid, String key, String value) {
        CeTaskCharacteristicDto dto = new CeTaskCharacteristicDto();
        dto.setTaskUuid(taskUuid);
        dto.setKey(key);
        dto.setValue(value);
        dto.setUuid(this.uuidFactory.create());
        return dto;
    }
}

