/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import java.util.List;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeTaskQuery;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.ce.ws.TaskFormatter;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsCe;

public class ComponentAction
implements CeWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final TaskFormatter formatter;
    private final ComponentFinder componentFinder;

    public ComponentAction(UserSession userSession, DbClient dbClient, TaskFormatter formatter, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.formatter = formatter;
        this.componentFinder = componentFinder;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("component").setDescription("Get the pending tasks, in-progress tasks and the last executed task of a given component (usually a project).<br>Requires the following permission: 'Browse' on the specified component.<br>Either '%s' or '%s' must be provided.", new Object[]{"componentId", "component"}).setSince("5.2").setResponseExample(this.getClass().getResource("component-example.json")).setChangelog(new Change[]{new Change("6.1", "field \"logs\" is deprecated and its value is always false"), new Change("6.6", "fields \"branch\" and \"branchType\" added")}).setHandler((RequestHandler)this);
        action.createParam("componentId").setRequired(false).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setDeprecatedSince("6.6");
        action.createParam("component").setRequired(false).setExampleValue((Object)"my_project").setDeprecatedKey("componentKey", "6.6");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, wsRequest);
            this.userSession.checkComponentPermission("user", component);
            List queueDtos = this.dbClient.ceQueueDao().selectByComponentUuid(dbSession, component.uuid());
            CeTaskQuery activityQuery = new CeTaskQuery().setComponentUuid(component.uuid()).setOnlyCurrents(true);
            List activityDtos = this.dbClient.ceActivityDao().selectByQuery(dbSession, activityQuery, Pagination.forPage((int)1).andSize(1));
            WsCe.ProjectResponse.Builder wsResponseBuilder = WsCe.ProjectResponse.newBuilder();
            wsResponseBuilder.addAllQueue(this.formatter.formatQueue(dbSession, queueDtos));
            if (activityDtos.size() == 1) {
                wsResponseBuilder.setCurrent(this.formatter.formatActivity(dbSession, (CeActivityDto)activityDtos.get(0), null));
            }
            WsUtils.writeProtobuf((Message)wsResponseBuilder.build(), wsRequest, wsResponse);
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request wsRequest) {
        String componentKey = wsRequest.param("component");
        String componentId = wsRequest.param("componentId");
        return this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT);
    }
}

