/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.queue.CeQueue;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;

public class CancelAction
implements CeWsAction {
    public static final String PARAM_TASK_ID = "id";
    private final UserSession userSession;
    private DbClient dbClient;
    private final CeQueue queue;

    public CancelAction(UserSession userSession, DbClient dbClient, CeQueue queue) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.queue = queue;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("cancel").setDescription("Cancels a pending task.<br/>In-progress tasks cannot be canceled.<br/>Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the project related to the task</li></ul>").setInternal(true).setPost(true).setSince("5.2").setHandler((RequestHandler)this);
        action.createParam(PARAM_TASK_ID).setRequired(true).setDescription("Id of the task to cancel.").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    public void handle(Request wsRequest, Response wsResponse) {
        String taskId = wsRequest.mandatoryParam(PARAM_TASK_ID);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional queueDto = this.dbClient.ceQueueDao().selectByUuid(dbSession, taskId);
            queueDto.ifPresent(dto -> {
                this.checkPermission(dbSession, (CeQueueDto)dto);
                this.queue.cancel(dbSession, (CeQueueDto)dto);
            });
        }
        wsResponse.noContent();
    }

    private void checkPermission(DbSession dbSession, CeQueueDto ceQueueDto) {
        if (this.userSession.isSystemAdministrator()) {
            return;
        }
        String componentUuid = ceQueueDto.getComponentUuid();
        if (componentUuid == null) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        com.google.common.base.Optional component = this.dbClient.componentDao().selectByUuid(dbSession, componentUuid);
        if (!component.isPresent()) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        this.userSession.checkComponentPermission("admin", (ComponentDto)component.get());
    }
}

