/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.FilePathWithHashDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.property.PropertyDto;
import org.sonar.scanner.protocol.input.FileData;
import org.sonar.scanner.protocol.input.ProjectRepositories;
import org.sonar.server.batch.ProjectDataQuery;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class ProjectDataLoader {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public ProjectDataLoader(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public ProjectRepositories load(ProjectDataQuery query) {
        try (DbSession session = this.dbClient.openSession(false);){
            ProjectRepositories data = new ProjectRepositories();
            String moduleKey = query.getModuleKey();
            String branch = query.getBranch();
            ComponentDto mainModule = this.componentFinder.getByKey(session, moduleKey);
            WsUtils.checkRequest(ProjectDataLoader.isProjectOrModule(mainModule), "Key '%s' belongs to a component which is not a Project", moduleKey);
            boolean hasScanPerm = this.userSession.hasComponentPermission("scan", mainModule) || this.userSession.hasPermission(OrganizationPermission.SCAN, mainModule.getOrganizationUuid());
            boolean hasBrowsePerm = this.userSession.hasComponentPermission("user", mainModule);
            ProjectDataLoader.checkPermission(query.isIssuesMode(), hasScanPerm, hasBrowsePerm);
            ComponentDto branchOrMainModule = branch == null ? mainModule : this.componentFinder.getByKeyAndBranch(session, moduleKey, branch);
            ComponentDto project = this.getProject(branchOrMainModule, session);
            if (!project.getKey().equals(branchOrMainModule.getKey())) {
                ProjectDataLoader.addSettings(data, branchOrMainModule.getKey(), this.getSettingsFromParents(branchOrMainModule, hasScanPerm, session));
            }
            List modulesTree = this.dbClient.componentDao().selectEnabledDescendantModules(session, branchOrMainModule.uuid());
            List modulesTreeSettings = this.dbClient.propertiesDao().selectEnabledDescendantModuleProperties(mainModule.uuid(), session);
            TreeModuleSettings treeModuleSettings = new TreeModuleSettings(session, modulesTree, modulesTreeSettings);
            ProjectDataLoader.addSettingsToChildrenModules(data, moduleKey, Maps.newHashMap(), treeModuleSettings, hasScanPerm);
            List<FilePathWithHashDto> files = this.searchFilesWithHashAndRevision(session, branchOrMainModule);
            ProjectDataLoader.addFileData(data, modulesTree, files);
            data.setLastAnalysisDate(new Date());
            ProjectRepositories projectRepositories = data;
            return projectRepositories;
        }
    }

    private static boolean isProjectOrModule(ComponentDto module) {
        if (!"PRJ".equals(module.scope())) {
            return false;
        }
        return "TRK".equals(module.qualifier()) || "BRC".equals(module.qualifier());
    }

    private List<FilePathWithHashDto> searchFilesWithHashAndRevision(DbSession session, @Nullable ComponentDto module) {
        if (module == null) {
            return Collections.emptyList();
        }
        return module.isRootProject() ? this.dbClient.componentDao().selectEnabledFilesFromProject(session, module.uuid()) : this.dbClient.componentDao().selectEnabledDescendantFiles(session, module.uuid());
    }

    private ComponentDto getProject(ComponentDto module, DbSession session) {
        if (!module.isRootProject()) {
            return this.dbClient.componentDao().selectOrFailByUuid(session, module.projectUuid());
        }
        return module;
    }

    private Map<String, String> getSettingsFromParents(ComponentDto module, boolean hasScanPerm, DbSession session) {
        ArrayList parents = Lists.newArrayList();
        this.aggregateParentModules(module, parents, session);
        Collections.reverse(parents);
        HashMap parentProperties = Maps.newHashMap();
        for (ComponentDto parent : parents) {
            parentProperties.putAll(ProjectDataLoader.getPropertiesMap(this.dbClient.propertiesDao().selectProjectProperties(session, parent.getKey()), hasScanPerm));
        }
        return parentProperties;
    }

    private void aggregateParentModules(ComponentDto component, List<ComponentDto> parents, DbSession session) {
        ComponentDto parent;
        String moduleUuid = component.moduleUuid();
        if (moduleUuid != null && (parent = this.dbClient.componentDao().selectOrFailByUuid(session, moduleUuid)) != null) {
            parents.add(parent);
            this.aggregateParentModules(parent, parents, session);
        }
    }

    private static void addSettingsToChildrenModules(ProjectRepositories ref, String moduleKey, Map<String, String> parentProperties, TreeModuleSettings treeModuleSettings, boolean hasScanPerm) {
        HashMap currentParentProperties = Maps.newHashMap();
        currentParentProperties.putAll(parentProperties);
        currentParentProperties.putAll(ProjectDataLoader.getPropertiesMap(treeModuleSettings.findModuleSettings(moduleKey), hasScanPerm));
        ProjectDataLoader.addSettings(ref, moduleKey, currentParentProperties);
        for (ComponentDto childModule : treeModuleSettings.findChildrenModule(moduleKey)) {
            ProjectDataLoader.addSettings(ref, childModule.getKey(), currentParentProperties);
            ProjectDataLoader.addSettingsToChildrenModules(ref, childModule.getKey(), currentParentProperties, treeModuleSettings, hasScanPerm);
        }
    }

    private static void addSettings(ProjectRepositories ref, String module, Map<String, String> properties) {
        if (!properties.isEmpty()) {
            ref.addSettings(module, properties);
        }
    }

    private static Map<String, String> getPropertiesMap(List<PropertyDto> propertyDtos, boolean hasScanPerm) {
        HashMap properties = Maps.newHashMap();
        for (PropertyDto propertyDto : propertyDtos) {
            String key = propertyDto.getKey();
            String value = propertyDto.getValue();
            if (!ProjectDataLoader.isPropertyAllowed(key, hasScanPerm)) continue;
            properties.put(key, value);
        }
        return properties;
    }

    private static boolean isPropertyAllowed(String key, boolean hasScanPerm) {
        return !key.contains(".secured") || hasScanPerm;
    }

    private static void addFileData(ProjectRepositories data, List<ComponentDto> moduleChildren, List<FilePathWithHashDto> files) {
        HashMap moduleKeysByUuid = Maps.newHashMap();
        for (ComponentDto module : moduleChildren) {
            moduleKeysByUuid.put(module.uuid(), module.getKey());
        }
        for (FilePathWithHashDto file : files) {
            FileData fileData = new FileData(file.getSrcHash(), file.getRevision());
            data.addFileData((String)moduleKeysByUuid.get(file.getModuleUuid()), file.getPath(), fileData);
        }
    }

    private static void checkPermission(boolean preview, boolean hasScanPerm, boolean hasBrowsePerm) {
        if (!hasBrowsePerm && !hasScanPerm) {
            throw new ForbiddenException("You're not authorized to execute any SonarQube analysis. Please contact your SonarQube administrator.");
        }
        if (!preview && !hasScanPerm) {
            throw new ForbiddenException("You're only authorized to execute a local (preview) SonarQube analysis without pushing the results to the SonarQube server. Please contact your SonarQube administrator.");
        }
        if (preview && !hasBrowsePerm) {
            throw new ForbiddenException("You don't have the required permissions to access this project. Please contact your SonarQube administrator.");
        }
    }

    private class TreeModuleSettings {
        private Map<String, ComponentDto> modulesByKey;
        private Multimap<String, PropertyDto> propertiesByModuleKey;
        private Multimap<String, ComponentDto> moduleChildrenByModuleUuid;

        private TreeModuleSettings(DbSession session, List<ComponentDto> moduleChildren, List<PropertyDto> moduleChildrenSettings) {
            this.modulesByKey = (Map)moduleChildren.stream().collect(MoreCollectors.uniqueIndex(ComponentDto::getKey));
            this.moduleChildrenByModuleUuid = ArrayListMultimap.create();
            Set propertiesByComponentId = (Set)moduleChildrenSettings.stream().map(PropertyDto::getResourceId).collect(MoreCollectors.toSet());
            Map componentsById = (Map)ProjectDataLoader.this.dbClient.componentDao().selectByIds(session, (Collection)propertiesByComponentId).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::getId));
            this.propertiesByModuleKey = (Multimap)moduleChildrenSettings.stream().collect(MoreCollectors.index(s -> ((ComponentDto)componentsById.get(s.getResourceId())).getKey()));
            this.moduleChildrenByModuleUuid = (Multimap)moduleChildren.stream().filter(c -> c.moduleUuid() != null).collect(MoreCollectors.index(ComponentDto::moduleUuid));
        }

        List<PropertyDto> findModuleSettings(String moduleKey) {
            return ImmutableList.copyOf((Collection)this.propertiesByModuleKey.get((Object)moduleKey));
        }

        List<ComponentDto> findChildrenModule(String moduleKey) {
            String moduleUuid = this.modulesByKey.get(moduleKey).uuid();
            return ImmutableList.copyOf((Collection)this.moduleChildrenByModuleUuid.get((Object)moduleUuid));
        }
    }
}

