/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.batch.BatchIndex;
import org.sonar.server.batch.BatchWsAction;

public class FileAction
implements BatchWsAction {
    private final BatchIndex batchIndex;

    public FileAction(BatchIndex batchIndex) {
        this.batchIndex = batchIndex;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("file").setInternal(true).setSince("4.4").setDescription("Download a JAR file listed in the index (see batch/index)").setResponseExample(this.getClass().getResource("batch-file-example.txt")).setHandler((RequestHandler)this);
        action.createParam("name").setDescription("File name").setExampleValue((Object)"batch-library-2.3.jar");
    }

    public void handle(Request request, Response response) throws Exception {
        String filename = request.mandatoryParam("name");
        try {
            response.stream().setMediaType("application/java-archive");
            File file = this.batchIndex.getFile(filename);
            FileUtils.copyFile((File)file, (OutputStream)response.stream().output());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

