/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.event;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class AuthenticationEventImpl
implements AuthenticationEvent {
    private static final Logger LOGGER = Loggers.get((String)"auth.event");
    private static final int FLOOD_THRESHOLD = 128;

    @Override
    public void loginSuccess(HttpServletRequest request, @Nullable String login, AuthenticationEvent.Source source) {
        AuthenticationEventImpl.checkRequest(request);
        Objects.requireNonNull(source, "source can't be null");
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("login success [method|{}][provider|{}|{}][IP|{}|{}][login|{}]", new Object[]{source.getMethod(), source.getProvider(), source.getProviderName(), request.getRemoteAddr(), AuthenticationEventImpl.getAllIps(request), AuthenticationEventImpl.preventLogFlood(AuthenticationEventImpl.emptyIfNull(login))});
    }

    private static String getAllIps(HttpServletRequest request) {
        return (String)Collections.list(request.getHeaders("X-Forwarded-For")).stream().collect(MoreCollectors.join((Joiner)Joiner.on((String)",")));
    }

    @Override
    public void loginFailure(HttpServletRequest request, AuthenticationException e) {
        AuthenticationEventImpl.checkRequest(request);
        Objects.requireNonNull(e, "AuthenticationException can't be null");
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        AuthenticationEvent.Source source = e.getSource();
        LOGGER.debug("login failure [cause|{}][method|{}][provider|{}|{}][IP|{}|{}][login|{}]", new Object[]{AuthenticationEventImpl.emptyIfNull(e.getMessage()), source.getMethod(), source.getProvider(), source.getProviderName(), request.getRemoteAddr(), AuthenticationEventImpl.getAllIps(request), AuthenticationEventImpl.preventLogFlood(AuthenticationEventImpl.emptyIfNull(e.getLogin()))});
    }

    @Override
    public void logoutSuccess(HttpServletRequest request, @Nullable String login) {
        AuthenticationEventImpl.checkRequest(request);
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("logout success [IP|{}|{}][login|{}]", new Object[]{request.getRemoteAddr(), AuthenticationEventImpl.getAllIps(request), AuthenticationEventImpl.preventLogFlood(AuthenticationEventImpl.emptyIfNull(login))});
    }

    @Override
    public void logoutFailure(HttpServletRequest request, String errorMessage) {
        AuthenticationEventImpl.checkRequest(request);
        Objects.requireNonNull(errorMessage, "error message can't be null");
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("logout failure [error|{}][IP|{}|{}]", new Object[]{AuthenticationEventImpl.emptyIfNull(errorMessage), request.getRemoteAddr(), AuthenticationEventImpl.getAllIps(request)});
    }

    private static void checkRequest(HttpServletRequest request) {
        Objects.requireNonNull(request, "request can't be null");
    }

    private static String emptyIfNull(@Nullable String login) {
        return login == null ? "" : login;
    }

    private static String preventLogFlood(String str) {
        if (str.length() > 128) {
            return str.substring(0, 128) + "...(" + str.length() + ")";
        }
        return str;
    }
}

