/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.sonar.server.authentication.Cookies;

public class OAuth2Redirection {
    private static final String REDIRECT_TO_COOKIE = "REDIRECT_TO";
    private static final String RETURN_TO_PARAMETER = "return_to";

    public void create(HttpServletRequest request, HttpServletResponse response) {
        Optional<String> redirectTo = OAuth2Redirection.sanitizeRedirectUrl(request.getParameter(RETURN_TO_PARAMETER));
        if (!redirectTo.isPresent()) {
            return;
        }
        response.addCookie(Cookies.newCookieBuilder(request).setName(REDIRECT_TO_COOKIE).setValue(redirectTo.get()).setHttpOnly(true).setExpiry(-1).build());
    }

    public Optional<String> getAndDelete(HttpServletRequest request, HttpServletResponse response) {
        Optional<Cookie> cookie = Cookies.findCookie(REDIRECT_TO_COOKIE, request);
        if (!cookie.isPresent()) {
            return Optional.empty();
        }
        this.delete(request, response);
        String redirectTo = cookie.get().getValue();
        if (Strings.isNullOrEmpty((String)redirectTo)) {
            return Optional.empty();
        }
        return Optional.of(redirectTo);
    }

    public void delete(HttpServletRequest request, HttpServletResponse response) {
        response.addCookie(Cookies.newCookieBuilder(request).setName(REDIRECT_TO_COOKIE).setValue(null).setHttpOnly(true).setExpiry(0).build());
    }

    private static Optional<String> sanitizeRedirectUrl(@Nullable String url) {
        if (Strings.isNullOrEmpty((String)url)) {
            return Optional.empty();
        }
        if (url.startsWith("//") || url.startsWith("/\\")) {
            return Optional.empty();
        }
        if (!url.startsWith("/")) {
            return Optional.empty();
        }
        return Optional.of(url);
    }
}

