/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import ch.qos.logback.classic.Level;
import org.sonar.process.ProcessId;
import org.sonar.process.logging.LogDomain;
import org.sonar.process.logging.LogLevelConfig;
import org.sonar.server.app.ServerProcessLogging;

public class WebServerProcessLogging
extends ServerProcessLogging {
    public WebServerProcessLogging() {
        super(ProcessId.WEB_SERVER, "%X{HTTP_REQUEST_ID}");
    }

    @Override
    protected void extendLogLevelConfiguration(LogLevelConfig.Builder logLevelConfigBuilder) {
        logLevelConfigBuilder.levelByDomain("sql", ProcessId.WEB_SERVER, LogDomain.SQL);
        logLevelConfigBuilder.levelByDomain("es", ProcessId.WEB_SERVER, LogDomain.ES);
        logLevelConfigBuilder.levelByDomain("auth.event", ProcessId.WEB_SERVER, LogDomain.AUTH_EVENT);
        JMX_RMI_LOGGER_NAMES.forEach(loggerName -> logLevelConfigBuilder.levelByDomain(loggerName, ProcessId.WEB_SERVER, LogDomain.JMX));
        logLevelConfigBuilder.offUnlessTrace("org.apache.catalina.core.ContainerBase");
        logLevelConfigBuilder.offUnlessTrace("org.apache.catalina.core.StandardContext");
        logLevelConfigBuilder.offUnlessTrace("org.apache.catalina.core.StandardService");
        LOGGER_NAMES_TO_TURN_OFF.forEach(loggerName -> logLevelConfigBuilder.immutableLevel(loggerName, Level.OFF));
    }

    @Override
    protected void extendConfigure() {
    }
}

