/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.JarScanner;
import org.sonar.api.utils.MessageException;
import org.sonar.core.util.FileUtils;
import org.sonar.process.Props;
import org.sonar.server.app.NullJarScanner;

public class TomcatContexts {
    public static final String PROPERTY_CONTEXT = "sonar.web.context";
    public static final String WEB_DEPLOY_PATH_RELATIVE_TO_DATA_DIR = "web/deploy";
    private final Fs fs;

    public TomcatContexts() {
        this.fs = new Fs();
    }

    @VisibleForTesting
    TomcatContexts(Fs fs) {
        this.fs = fs;
    }

    public StandardContext configure(Tomcat tomcat, Props props) {
        this.addStaticDir(tomcat, TomcatContexts.getContextPath(props) + "/deploy", new File(props.nonNullValueAsFile("sonar.path.data"), WEB_DEPLOY_PATH_RELATIVE_TO_DATA_DIR));
        StandardContext webapp = TomcatContexts.addContext(tomcat, TomcatContexts.getContextPath(props), TomcatContexts.webappDir(props));
        for (Map.Entry<Object, Object> entry : props.rawProperties().entrySet()) {
            String key = entry.getKey().toString();
            webapp.addParameter(key, entry.getValue().toString());
        }
        return webapp;
    }

    static String getContextPath(Props props) {
        String context = props.value(PROPERTY_CONTEXT, "");
        if ("/".equals(context)) {
            context = "";
        } else if (!"".equals(context) && context != null && !context.startsWith("/")) {
            throw MessageException.of((String)String.format("Value of '%s' must start with a forward slash: '%s'", PROPERTY_CONTEXT, context));
        }
        return context;
    }

    @VisibleForTesting
    StandardContext addStaticDir(Tomcat tomcat, String contextPath, File dir) {
        try {
            this.fs.createOrCleanupDir(dir);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to create or clean-up directory %s", dir.getAbsolutePath()), e);
        }
        return TomcatContexts.addContext(tomcat, contextPath, dir);
    }

    private static StandardContext addContext(Tomcat tomcat, String contextPath, File dir) {
        try {
            StandardContext context = (StandardContext)tomcat.addWebapp(contextPath, dir.getAbsolutePath());
            context.setClearReferencesHttpClientKeepAliveThread(false);
            context.setClearReferencesStopThreads(false);
            context.setClearReferencesStopTimerThreads(false);
            context.setClearReferencesStopTimerThreads(false);
            context.setAntiResourceLocking(false);
            context.setReloadable(false);
            context.setUseHttpOnly(true);
            context.setTldValidation(false);
            context.setXmlValidation(false);
            context.setXmlNamespaceAware(false);
            context.setUseNaming(false);
            context.setDelegate(true);
            context.setJarScanner((JarScanner)new NullJarScanner());
            context.setAllowCasualMultipartParsing(true);
            context.setCookies(false);
            context.setContainerSciFilter("org.apache.tomcat.websocket.server.WsSci|org.apache.jasper.servlet.JasperInitializer");
            return context;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to configure webapp from " + dir, e);
        }
    }

    private static File webappDir(Props props) {
        return new File(props.value("sonar.path.home"), "web");
    }

    static class Fs {
        Fs() {
        }

        void createOrCleanupDir(File dir) throws IOException {
            org.apache.commons.io.FileUtils.forceMkdir((File)dir);
            FileUtils.cleanDirectory((File)dir);
        }
    }
}

